/*
* @file mmplaying_state.cpp
* @brief Definition of MMPlayingState class
* @date Feb. 20, 2007
*
* DIALOGIC CONFIDENTIAL
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#include "mmlib.h"
#include "mmplaying_state.h"
#include "mmendpoint.h"
#include "endpointmgr.h"
#include "logger.h"

#include "appevents.h"

//*****************************************************************************
// Function: MMPlayingState::MMPlayingState(MMEndpoint *pMMEndpoint)
// Description: Initializing constructor
// Return:  MMPlayingState*
// Parameters: MMEndpoint *pMMEndpoint 
//*****************************************************************************
MMPlayingState::MMPlayingState(MMEndpoint* pMMEndpoint) :
   MMEPState(pMMEndpoint)
{
}

//*****************************************************************************
// Function: MMPlayingState::~MMPlayingState()
// Description: Destructor
// Return:  none
// Parameters: none 
//*****************************************************************************
MMPlayingState::~MMPlayingState()
{
}

//*****************************************************************************
// Function: void MMPlayingState::ProcessEvent(METAEVENT metaevent)
// Description: Process an event
// Return: none 
// Parameters: METAEVENT metaevent 
//*****************************************************************************
void MMPlayingState::ProcessEvent(METAEVENT metaevent)
{
   switch ( metaevent.evttype )
   {
    case MMEV_PLAY_ACK:
      LOG_ENTRY(metaevent.evtdev, "MMPlaying state: Event MMEV_PLAY_ACK received\n");
        break;
    case MMEV_STOP_ACK:
      LOG_ENTRY(metaevent.evtdev, "MMPlaying state: Event MMEV_STOP_ACK received\n");
      ProcessPlayStopAckRcvd(metaevent);
        break;
    case M3GEV_H245_UII_RCVD:
      LOG_ENTRY(metaevent.evtdev, "MMPlaying state: Event M3GEV_H245_UII_RCVD received\n");
      // This event is a little odd, as it has arrived at this MM endpoints 3G peer.  But
      // might as well use it as any other event value for UII/DTMF notification.
      // commented to stop only with Run Time Control option
      ProcessUIIRcvd(metaevent);
        break;
    case MMEV_PLAY:
      LOG_ENTRY(metaevent.evtdev, "MMPlaying state: Event MMEV_PLAY received\n");
      ProcessPlayDone(metaevent);
        break;
    case MMEV_PLAY_ACK_FAIL:
      LOG_ENTRY(metaevent.evtdev, "MMPlaying state: Event MMEV_PLAY_FAIL_ACK received\n");
      Shutdown();
        break;
    case MMEV_STOP_ACK_FAIL:
      LOG_ENTRY(metaevent.evtdev, "MMPlaying state: Event MMEV_STOP_FAIL_ACK received\n");
      Shutdown();
        break;
    default:
         LOG_ERROR(metaevent.evtdev,"MMPlaying state: Unexpected event type: 0x%x\n",
		   metaevent.evttype);
         break;
   }
}

void MMPlayingState::ProcessUIIRcvd(METAEVENT metaevent)
{
  char *UIIPtr = (char *) metaevent.evtdatap;

  // Simple here - any UII/DTMF triggers a mm_Stop to terminate play.
  m_pMMEndpoint->SetLastDigitRcvd(UIIPtr[0]);
  LOG_ENTRY(metaevent.evtdev, "UII %c received - terminating play\n",*UIIPtr);
  m_pMMEndpoint->StopMMPlay();
}

//*****************************************************************************
// Function: void MMPlayingState::Shutdown()
// Description: Process shutdown request
// Return: void 
// Parameters: none 
//*****************************************************************************
void MMPlayingState::Shutdown()
{
  LOG_ENTRY(m_pMMEndpoint->GetMMHandle(), "Shutdown called in %s state.  No Op\n", GetStateStr());
}


void MMPlayingState::ProcessPlayDone(METAEVENT metaevent)
{
  // Change state back to idle, and notify this endpoint's BridgedMedia
  m_pMMEndpoint->ChangeState(IDLE_STATE);
  m_pMMEndpoint->Notify(APP_MM_ENDPOINT_IDLE);
}

void MMPlayingState::ProcessPlayStopAckRcvd(METAEVENT metaevent)
{
  // Can be used if further info is wanted on stop ack event
  //MM_STOP_ACK* pStopAck = reinterpret_cast<MM_STOP_ACK*>(metaevent.evtdatap);
}

