/**
* @file mmidle_state.cpp
* @brief Definition of RTSPIdleState class
* @date Feb. 20, 2007
*
* DIALOGIC CONFIDENTIAL
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#include "ipmlib.h"
#include "rtspidle_state.h"
#include "rtspendpoint.h"
#include "endpointmgr.h"
#include "logger.h"

#include "appevents.h"

//*****************************************************************************
// Function: RTSPIdleState::RTSPIdleState(RTSPEndpoint *pRTSPEndpoint)
// Description: Initializing constructor
// Return:  RTSPIdleState*
// Parameters: RTSPEndpoint *pRTSPEndpoint 
//*****************************************************************************
RTSPIdleState::RTSPIdleState(RTSPEndpoint* pRTSPEndpoint) :
   RTSPEPState(pRTSPEndpoint)
{
   m_PortDiscCount = 0;
}

//*****************************************************************************
// Function: RTSPIdleState::~RTSPIdleState()
// Description: Destructor
// Return:  none
// Parameters: none 
//*****************************************************************************
RTSPIdleState::~RTSPIdleState()
{
}

//*****************************************************************************
// Function: void RTSPIdleState::ProcessEvent(METAEVENT metaevent)
// Description: Process an event
// Return: none 
// Parameters: METAEVENT metaevent 
//*****************************************************************************
void RTSPIdleState::ProcessEvent(METAEVENT metaevent)
{
   switch ( metaevent.evttype )
   {
#if 0
    case RTSPEV_PLAY_ACK:
      LOG_ENTRY(metaevent.evtdev, "Event RTSPEV_PLAY_ACK received\n");
      ProcessPlayStarted(metaevent);
        break;
    case RTSPEV_RECORD_ACK:
      LOG_ENTRY(metaevent.evtdev, "Event RTSPEV_RECORD_ACK received\n");
      ProcessRecordStarted(metaevent);
        break;
    case RTSPEV_PLAY_ACK_FAIL:
      LOG_ENTRY(metaevent.evtdev, "Event RTSPEV_PLAY_ACK_FAIL received\n");
      retCode = mm_ErrorInfo(&mmInfo);
      LOG_ENTRY(0, "  mm_value=%#x,mmMsg=%s,addInfo=%s \n",mmInfo.mmValue,mmInfo.mmMsg,mmInfo.additionalInfo);
      break; 
    case RTSPEV_RECORD_ACK_FAIL:
      LOG_ENTRY(metaevent.evtdev, "Event RTSPEV_PLAY_ACK_FAIL received\n");
        break; 
#endif
   case IPMEV_STARTMEDIA:
      LOG_ENTRY(metaevent.evtdev, "RTSPIdle state: IPMEV_STARTMEDIA received\n");
      ProcessMediaStarted(metaevent);
      break;
   case IPMEV_STOPPED:
      LOG_ENTRY(metaevent.evtdev, "RTSPIdle state: IPMEV_STOPPED received\n");
      break;
   case IPMEV_ERROR:
      LOG_ENTRY(metaevent.evtdev, "RTSPIdle state: IPMEV_ERROR received\n");
      break;
   case M3GEV_H245_UII_RCVD:
      LOG_ENTRY(metaevent.evtdev, "RTSPIdle state: M3GEV_H245_UII_RCVD\n");
      ProcessUIIRcvd(metaevent);
      break;
   case DMEV_PORT_DISCONNECT:
      LOG_ENTRY(metaevent.evtdev, "RTSPIdle state: DMEV_PORT_DISCONNECT received\n");
      ProcessPortDisconnect(metaevent.evtdev);
      break;
    default:
      LOG_ERROR(metaevent.evtdev,"RTSPIdle state: Unexpected event type: 0x%x\n",metaevent.evttype);
       break;
   }
}

void RTSPIdleState::ProcessPlayStarted(METAEVENT metaevent)
{
  m_pRTSPEndpoint->Notify(APP_RTSP_ENDPOINT_PLAYING);
  m_pRTSPEndpoint->ChangeState(PLAYING_STATE);
}

void RTSPIdleState::ProcessMediaStarted(METAEVENT metaevent)
{
  m_pRTSPEndpoint->Notify(APP_RTSP_ENDPOINT_PLAYING);
  m_pRTSPEndpoint->RTSPServerPlay();
  m_pRTSPEndpoint->ChangeState(PLAYING_STATE);
}

void RTSPIdleState::ProcessRecordStarted(METAEVENT metaevent)
{
  m_pRTSPEndpoint->Notify(APP_RTSP_ENDPOINT_RECORDING);
  m_pRTSPEndpoint->ChangeState(RECORDING_STATE);
}

//*****************************************************************************
// Function: void RTSPIdleState::Shutdown()
// Description: Process shutdown request
// Return: void 
// Parameters: none 
//*****************************************************************************
void RTSPIdleState::Shutdown()
{
  LOG_ENTRY(m_pRTSPEndpoint->GetIPMHandle(), "Shutdown called in %s state.  No Op\n", GetStateStr());
  m_pRTSPEndpoint->DisconnectFromPeer();
  //m_pRTSPEndpoint->ReleaseResources();

}

void RTSPIdleState::ProcessUIIRcvd(METAEVENT metaevent)
{
  char *UIIPtr = (char *) metaevent.evtdatap;

  // Simple here - any UII/DTMF triggers a mm_Stop to terminate play.
  LOG_ENTRY(metaevent.evtdev, "UII %c received - terminating play\n", *UIIPtr);
  m_pRTSPEndpoint->PlayVideoFile(*UIIPtr);
}

void RTSPIdleState::ProcessPortDisconnect(int evtDev)
{
      m_PortDiscCount++;
      if (m_PortDiscCount == 2) {
         LOG_ENTRY(evtDev," RTSPIdleState: Audio and Video Ports Disconnected\n");
         m_pRTSPEndpoint->CloseSubDevs();
         m_pRTSPEndpoint->ChangeState(CLOSED_STATE);
         m_pRTSPEndpoint->Notify(APP_RTSP_ENDPOINT_DISCONNECTED);
      }
}

