/*
* @file mmplaying_state.cpp
* @brief Definition of RTSPPlayingState class
* @date Feb. 20, 2007
*
* DIALOGIC CONFIDENTIAL
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#include "ipmlib.h"
#include "rtspplaying_state.h"
#include "rtspendpoint.h"
#include "endpointmgr.h"
#include "logger.h"

#include "appevents.h"

//*****************************************************************************
// Function: RTSPPlayingState::RTSPPlayingState(RTSPEndpoint *pRTSPEndpoint)
// Description: Initializing constructor
// Return:  RTSPPlayingState*
// Parameters: RTSPEndpoint *pRTSPEndpoint 
//*****************************************************************************
RTSPPlayingState::RTSPPlayingState(RTSPEndpoint* pRTSPEndpoint) :
   RTSPEPState(pRTSPEndpoint)
{
}

//*****************************************************************************
// Function: RTSPPlayingState::~RTSPPlayingState()
// Description: Destructor
// Return:  none
// Parameters: none 
//*****************************************************************************
RTSPPlayingState::~RTSPPlayingState()
{
}

//*****************************************************************************
// Function: void RTSPPlayingState::ProcessEvent(METAEVENT metaevent)
// Description: Process an event
// Return: none 
// Parameters: METAEVENT metaevent 
//*****************************************************************************
void RTSPPlayingState::ProcessEvent(METAEVENT metaevent)
{
   switch ( metaevent.evttype )
   {
#if 0
    case RTSPEV_PLAY_ACK:
      LOG_ENTRY(metaevent.evtdev, "Event RTSPEV_PLAY_ACK received\n");
        break;
    case RTSPEV_STOP_ACK:
      LOG_ENTRY(metaevent.evtdev, "Event RTSPEV_STOP_ACK received\n");
      ProcessPlayStopAckRcvd(metaevent);
        break;
    case M3GEV_H245_UII_RCVD:
      LOG_ENTRY(metaevent.evtdev, "Event M3GEV_H245_UII_RCVD received\n");
      // This event is a little odd, as it has arrived at this RTSP endpoints 3G peer.  But
      // might as well use it as any other event value for UII/DTMF notification.
       ProcessUIIRcvd(metaevent);
        break;
    case RTSPEV_PLAY:
      LOG_ENTRY(metaevent.evtdev, "Event RTSPEV_PLAY received\n");
      ProcessPlayDone(metaevent);
        break;
    case RTSPEV_PLAY_ACK_FAIL:
      LOG_ENTRY(metaevent.evtdev, "Event RTSPEV_PLAY_FAIL_ACK received\n");
        break;
    case RTSPEV_STOP_ACK_FAIL:
      LOG_ENTRY(metaevent.evtdev, "Event RTSPEV_STOP_FAIL_ACK received\n");
        break;
#endif
    case M3GEV_H245_UII_RCVD:
      LOG_ENTRY(metaevent.evtdev, "Event M3GEV_H245_UII_RCVD received in RTSPPlayingState\n");
      // This event is a little odd, as it has arrived at this RTSP endpoints 3G peer.  But
      // might as well use it as any other event value for UII/DTMF notification.
      ProcessUIIRcvd(metaevent);
        break;

    case IPMEV_STOPPED:
      ProcessPlayDone(metaevent);
       break;
    default:
         LOG_ERROR(metaevent.evtdev,"RTSPPlaying state: Unexpected event type: 0x%x\n",
		   metaevent.evttype);
         break;
   }
}

void RTSPPlayingState::ProcessUIIRcvd(METAEVENT metaevent)
{
  char *UIIPtr = (char *) metaevent.evtdatap;
 
  // Simple here - any UII/DTMF triggers a mm_Stop to terminate play.
  LOG_ENTRY(metaevent.evtdev, "UII %c received - terminating play\n", *UIIPtr);
  m_pRTSPEndpoint->StopRTSPPlay();
  m_pRTSPEndpoint->QueueNextVideo(*UIIPtr);
}

//*****************************************************************************
// Function: void RTSPPlayingState::Shutdown()
// Description: Process shutdown request
// Return: void 
// Parameters: none 
//*****************************************************************************
void RTSPPlayingState::Shutdown()
{
  LOG_ENTRY(m_pRTSPEndpoint->GetIPMHandle(), "Shutdown called in %s state.  No Op\n", GetStateStr());
}


void RTSPPlayingState::ProcessPlayDone(METAEVENT metaevent)
{
  // Change state back to idle, and notify this endpoint's BridgedMedia
  m_pRTSPEndpoint->ChangeState(IDLE_STATE);
  m_pRTSPEndpoint->Notify(APP_RTSP_ENDPOINT_IDLE);
}

void RTSPPlayingState::ProcessPlayStopAckRcvd(METAEVENT metaevent)
{
  // Can be used if further info is wanted on stop ack event
  //RTSP_STOP_ACK* pStopAck = reinterpret_cast<RTSP_STOP_ACK*>(metaevent.evtdatap);
}

