/**
* @file txmediaactive_state.h
* @brief Declaration of MediaActiveState class
* @date Feb. 16, 2007
*
* DIALOGIC CONFIDENTIAL
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#ifndef  _RXMEDIASTOPPED_STATE_H
#define  _RXMEDIASTOPPED_STATE_H

#include "epstate.h"

class RxMediaStoppedState : public EPState  
{
public:
    RxMediaStoppedState(Endpoint* pEndpoint);
    ~RxMediaStoppedState();
    virtual void ProcessEvent(long  evtType, void *pEvtData, long  evtLen, long  evtDev);
    virtual void ProcessUserPrompt(EPState::E_USER_PROMPT_TYPE eUserPrompt);
    virtual void Shutdown();
    virtual const char *GetStateStr() { return "RX_MEDIA_STOPPED   ";}
    virtual E_EPSTATE GetState() { return RX_MEDIA_STOPPED_STATE;}

private:
    static const int AUDIO_STOPPED;   // 0x01
    static const int VIDEO_STOPPED;   // 0x02
    static const int MEDIA_STOPPED;   // 0x03
    static const int MEDIA_STOPPING;  // 0x10;

    void ProcessResetComplete();
    void StopMedia();
    void CheckMediaStopped();
};

#endif 
