/**
* @file sipepstate.h
* @brief Declaration of SIPEPState class
* @date Feb. 20, 2007
*
* DIALOGIC CONFIDENTIAL
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#ifndef  _SIPEPSTATE_H
#define  _SIPEPSTATE_H

#include "gclib.h"
#include "statusbitmask.h"

class SIPEndpoint;

//*****************************************************************************
// Class: ::SIPEPState
// Description: Abstract class for all SIP endpoint states
//*****************************************************************************
class SIPEPState : public StatusBitmask
{
public:
   typedef enum
   {
      OPENING_STATE,
      RESERVINGMEDIA_STATE,
      PORTCONNECTING_STATE,
      IDLE_STATE,
      CALLING_STATE,
      CONNECTED_STATE,
      DROPPING_STATE,
      RELEASING_STATE,
      OFFERED_STATE,
      CLOSED_STATE,
      UNDEFINED_STATE,
      NUM_SIPEP_STATES
   }  E_SIPEPSTATE;

   typedef enum
   {
      USER_CONNECT_PROMPT,
      USER_DISCONNECT_PROMPT,
      USER_SEND_DIGIT_PROMPT,
      USER_SEND_FVU_PROMPT
   }  E_USER_PROMPT_TYPE;

   SIPEPState(SIPEndpoint* pSIPEndpoint);
   virtual ~SIPEPState();
   virtual void ProcessEvent(METAEVENT metaevent) = 0;
   virtual void Shutdown() = 0;
   virtual const char* GetStateStr() = 0;
   virtual E_SIPEPSTATE GetState() = 0;

protected:
   SIPEndpoint *m_pSIPEndpoint;
};

#endif

