/**
* @file sipoffered_state.cpp
* @brief Definition of SIPOfferedState class
* @date Feb. 20, 2007
*
* DIALOGIC CONFIDENTIAL
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/


#include "sipoffered_state.h"
#include "sipendpoint.h"
#include "endpointmgr.h"
#include "logger.h"
#include "appevents.h"

//*****************************************************************************
// Function: SIPOfferedState::SIPOfferedState(SIPEndpoint *pSIPEndpoint)
// Description: Initializing constructor
// Return:  SIPOfferedState*
// Parameters: SIPEndpoint *pSIPEndpoint 
//*****************************************************************************
SIPOfferedState::SIPOfferedState(SIPEndpoint* pSIPEndpoint) :
              SIPEPState(pSIPEndpoint)
{
   m_pSIPEndpoint = pSIPEndpoint;
}


//*****************************************************************************
// Function: SIPOfferedState::~SIPOfferedState()
// Description: Destructor
// Return:  none
// Parameters: none 
//*****************************************************************************
SIPOfferedState::~SIPOfferedState()
{
   // place holder for now
}


//*****************************************************************************
// Function: bool SIPOfferedState::ProcessEvent(long evtType, void *pEvtData, long evtLen, long evtDev)
// Description: Process an event
// Return: bool 
// Parameters: long evtType 
//             void *pEvtData 
//             long evtLen 
//             long evtDev 
//*****************************************************************************
void SIPOfferedState::ProcessEvent(METAEVENT metaevent)
{
   switch (metaevent.evttype)
   {
   case GCEV_ANSWERED:
     LOG_ENTRY(metaevent.evtdev, "SipOfferedState: GCEV_ANSWERED received\n");
     ProcessAnswered(metaevent);
     break;
     
   case GCEV_DISCONNECTED:
     LOG_ENTRY(metaevent.evtdev, "SipOfferedState: GCEV_DISCONNECTED received\n");
     ProcessDisconnect(metaevent);
     break;
     
   default:
     LOG_ERROR(metaevent.evtdev,"SipOfferedState: Unexpected event type: 0x%x\n", metaevent.evttype);
     break;
   }
}


//*****************************************************************************
// Function: void SIPOfferedState::ProcessUserPrompt(SIPEPState::E_USER_PROMPT_TYPE eUserPrompt)
// Description: Process request from user interface
// Return: void 
// Parameters: SIPEPState::E_USER_PROMPT_TYPE eUserPrompt 
//*****************************************************************************
void  SIPOfferedState::ProcessUserPrompt(SIPEPState::E_USER_PROMPT_TYPE eUserPrompt)
{
   LOG_ERROR(0,"Unexpected user prompt on SIP endpoint in OFFERED state: %d\n",
             static_cast<int>(eUserPrompt));
}

//*****************************************************************************
// Function: void SIPOfferedState::ProcessAnswered(METAEVENT metaevent)
// Description: Process answered event
// Return: void
// Parameters: METAEVENT metaevent
//*****************************************************************************
void SIPOfferedState::ProcessAnswered(METAEVENT metaevent)
{
   // Start Media streaming
   m_pSIPEndpoint->ProcessCallAnswered(metaevent);
   m_pSIPEndpoint->Notify(APP_SIP_ENDPOINT_ANSWERED);
   // Advance to connected state
   m_pSIPEndpoint->ChangeState(CONNECTED_STATE);
}

//*****************************************************************************
// Function: void SIPOfferedState::ProcessDisconnect(METAEVENT metaevent)
// Description: Process disconnect event
// Return: void
// Parameters: METAEVENT metaevent
//*****************************************************************************
void SIPOfferedState::ProcessDisconnect(METAEVENT metaevent)
{
   m_pSIPEndpoint->Notify(APP_SIP_ENDPOINT_DISCONNECT);
   // Advance to dropping state
   m_pSIPEndpoint->ChangeState(DROPPING_STATE);
   m_pSIPEndpoint->DropCall(metaevent);
}


//*****************************************************************************
// Function: void SIPOfferedState::Shutdown()
// Description: Process shutdown request
// Return: void 
// Parameters: none 
//*****************************************************************************
void SIPOfferedState::Shutdown()
{
  LOG_ENTRY(m_pSIPEndpoint->GetGCSIPHandle(), "Shutdown called in %s state.  No Op\n", GetStateStr());
}


