/**
* @file statusbitmask.h
* @brief Declaration of Abstract class for maintaining status bitmask
* @date Feb. 16, 2007
*
* DIALOGIC CONFIDENTIAL
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#ifndef  _STATUSBITMASK_H
#define  _STATUSBITMASK_H

//*****************************************************************************
// Class: ::StatusBitmask
// Description: Class for processing state bitmask
//*****************************************************************************
class StatusBitmask
{
public:
   StatusBitmask() : m_StatusBitmask(0){};
   virtual ~StatusBitmask() {};
   virtual void Reset() { ClearAllStatus();}
   virtual const char* GetStateStr() = 0;
   void SetStatus(int status) { m_StatusBitmask |= status;}
   void ClearStatus(int status) { m_StatusBitmask &= (~status);}
   void ClearAllStatus() { m_StatusBitmask = 0;}
   bool IsStatusSet(int status) { return (status == (m_StatusBitmask & status));}

protected:
   int       m_StatusBitmask;
};

#endif

