/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* DIALOGIC CONFIDENTIAL
*
* Copyright (C) 2006-2007 Dialogic Corporation. All Rights Reserved.
* The source code contained or described herein and all documents related
* to the source code ("Material") are owned by Dialogic Corporation or its
* suppliers or licensors. Title to the Material remains with Dialogic Corporation
* or its suppliers and licensors. The Material contains trade secrets and
* proprietary and confidential information of Dialogic or its suppliers and
* licensors. The Material is protected by worldwide copyright and trade secret
* laws and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted, distributed,
* or disclosed in any way without Dialogic's prior express written permission.
*
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
//***********************************************************************
//***********************************************************************
// SrlHandle.h: interface for the CSrlHandle class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_CNFBOARD_H__CC636419_19FE_40C5_B8F3_169025E4C405__INCLUDED_)
#define AFX_CNFBOARD_H__CC636419_19FE_40C5_B8F3_169025E4C405__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000



typedef class CnfBoard * PCnfBoard;

class CnfBoard : public CSrlDeviceContainer {
public:
	CnfBoard(PCommonParams pCommonParams,
             PBrdParams pBrdParams,
             PCnfPrmContainer pCnfPrmContainer);
	virtual ~CnfBoard();

    // Handle new event
    virtual void HandleEvent(int event,               // event code
                             void *evtdata,           // event data (if any)
                             int evtlen,              // event length    
                             METAEVENT *metaeventp);  // metaevent 
    
    virtual const char *action_name(int action);
    virtual const char *state_name(int state);

    bool FindConferenceByPassCode(const char *pass_code, PCnfConference *ppConf);
    bool FindConferenceById(int id, PCnfConference *ppConf);

    void Dump();

    virtual bool Execute(int action);

    virtual void dump_notification_data(int event, void *evtdata){
        // forward to cnf version
        cnf_dump_notification_data(event, evtdata);
    }

    SRL_DEVICE_HANDLE OpenParty(PSrlDevice pDev);
    bool CloseParty(SRL_DEVICE_HANDLE srl_handle);

private:
    bool SetAttributes();
    bool EnableEvents();
    bool DisableEvents();
    bool GetDeviceCount();

    bool CreateConferences();
    bool TryClose();    // close only if conference count is == 0
    bool Open();

protected:
    virtual bool Close();


private:

    ECNF_ATTR_STATE brd_ActiveTalker;     // 
    int  brd_ATInterval;       // active talker notify interval
	ECNF_ATTR_STATE brd_DTMFClamping;     // 
    MSG_TYPE brd_PrivateLog;
    int  m_max_conf_count;         // total number of possible conferences 
    int  m_number_of_conferences;  // current number of conferences
    int  m_number_of_parties;      // current number of opened parties

   private:
       PBrdParams m_pBrdParams;
       PCnfPrmContainer m_pCnfPrmContainer;
}; // class CnfBoard


// A list of conference boards
typedef class ConferencePool * PConferencePool;

class ConferencePool :public list<PCnfBoard> {
   public:
       ConferencePool(){};
       ~ConferencePool(){};
       bool FindConferenceByPassCode(const char *pass_code, PCnfConference *ppConf){
           list<PCnfBoard>::iterator pos;
           for ( pos = begin(); pos != end(); ++pos) {
              if ( (*pos)->FindConferenceByPassCode(pass_code, ppConf) ){
                    return true;
              }
           }
           return false;
       }  

       bool FindConferenceById(int id, PCnfConference *ppConf){
           list<PCnfBoard>::iterator pos;
           for ( pos = begin(); pos != end(); ++pos) {
              if ( (*pos)->FindConferenceById(id, ppConf) ){
                    return true;
              }
           }
           return false;
       }

       size_t GetNumberOfConferences(){
           size_t num = 0;
           list<PCnfBoard>::iterator pos;
           for ( pos = begin(); pos != end(); ++pos) {
              num += (*pos)->size();
           }
           return num;
       }

}; // Class ConferencePool



#endif // !defined(AFX_CNFBOARD_H__CC636419_19FE_40C5_B8F3_169025E4C405__INCLUDED_)
