/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* DIALOGIC CONFIDENTIAL
*
* Copyright (C) 2006-2007 Dialogic Corporation. All Rights Reserved.
* The source code contained or described herein and all documents related
* to the source code ("Material") are owned by Dialogic Corporation or its
* suppliers or licensors. Title to the Material remains with Dialogic Corporation
* or its suppliers and licensors. The Material contains trade secrets and
* proprietary and confidential information of Dialogic or its suppliers and
* licensors. The Material is protected by worldwide copyright and trade secret
* laws and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted, distributed,
* or disclosed in any way without Dialogic's prior express written permission.
*
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
//***********************************************************************
//***********************************************************************
// ConfigFile.h: interface for the ConfigFile class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_CONFIGFILE_H__9C41BA06_194F_47C8_AE4E_4BBFDFE239CB__INCLUDED_)
#define AFX_CONFIGFILE_H__9C41BA06_194F_47C8_AE4E_4BBFDFE239CB__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "CParser.h"

// Error codes
typedef enum {
    CFG_OK,
    CFG_ERR_OPEN,
    CFG_ERR_READ,
    CFG_ERR_FORMAT,

    CFG_ERR_LAST
}CFG_ERROR;


// Return text for given error code
const char *cfg_get_errormsg(CFG_ERROR error);


//
// file reader and parser
// 
typedef class ConfigFile * PConfigFile;

class ConfigFile : public CParser {

 public:
	ConfigFile(CGenLog *pLog);
	virtual ~ConfigFile();

    // Load at once entire file into memory
    CFG_ERROR LoadConfigFile(const char *FileName);

    // Returns current file name
    const char *GetFileName(){
        return m_file_name;
    }

 private:
    void DeleteBuffer();       // delete allocated space and init internal variables
    char * m_file_buf;         // file buffer
    char * m_file_name;        // file name currently loaded

}; // class ConfigFile

#endif // !defined(AFX_CONFIGFILE_H__9C41BA06_194F_47C8_AE4E_4BBFDFE239CB__INCLUDED_)
