/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* DIALOGIC CONFIDENTIAL
*
* Copyright (C) 2006-2007 Dialogic Corporation. All Rights Reserved.
* The source code contained or described herein and all documents related
* to the source code ("Material") are owned by Dialogic Corporation or its
* suppliers or licensors. Title to the Material remains with Dialogic Corporation
* or its suppliers and licensors. The Material contains trade secrets and
* proprietary and confidential information of Dialogic or its suppliers and
* licensors. The Material is protected by worldwide copyright and trade secret
* laws and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted, distributed,
* or disclosed in any way without Dialogic's prior express written permission.
*
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
//***********************************************************************
//***********************************************************************

// FileLog.cpp: implementation of the CFileLog class.
// Log a message into file
//
//////////////////////////////////////////////////////////////////////
// ignore MSC2005 fopen/fopen_s security warning
#define _CRT_SECURE_NO_WARNINGS
#include <fcntl.h>
#undef _CRT_SECURE_NO_WARNINGS

#include <stdio.h>


#include "utils.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////
//*****************************************************************************
// Purpose	: 
//    Constructor
// Parameters:	
//    none
// Returns:	
//    none
//*****************************************************************************
CFileLog::CFileLog() {
	m_hFile = 0;
    m_LogFileName = 0;
	str_storestring(&m_LogFileName , "DemoLog.log");
	m_MaxSize	=	100000; // max lines in the file
	m_CurrentSize   = 0; // currently lines in the file
    m_ErrOpen = false;
}  //	End of constructor()

CFileLog::~CFileLog() {
	CloseLogFile();
}  //	End of destructor()

//*****************************************************************************
// Purpose	: 
//    Advance to the new line and log
// Parameters:
//  [in] msg_type: verbosity level	
//  [in] message:  what to log
// Returns:	
//    success (true / false ) 
//*****************************************************************************
bool CFileLog::doLog(MSG_TYPE msg_type, const char *message) {
int rc = 0;
    if (CanOutput(msg_type) ) {
	    if(m_hFile == 0)	{
            if (!m_ErrOpen) {
                // first time open
		        if( !OpenLogFile() )	{
                    // error opening file
			         return false;
                }
            }else {
                // previous error opening file
                return false;
            }
        } // if m_hFile

        fprintf(m_hFile, STR_NEWLINE"%s",message);
        if (    CanOutput(LOG_DBG)
             || (msg_type >= LOG_ERR1) 
           ) {
            //  when in debug mode,
            //  or error message was print,
            //  make it available immediately
            fflush(m_hFile); 
        }
        ++m_CurrentSize;
        CheckFileSize();
    } // if CanOutput

 return (rc >= 0);
}  //	End of doLog()

//////////////////////////////////////////////////////////////////////
// Public methods
//////////////////////////////////////////////////////////////////////
//*****************************************************************************
// Purpose	: 
//    Create the log file that will be used by the application to log
//    information
// Parameters:	
//    [in] file name 
//    [in] maximum size in lines. After reaching max size, rename to <file.bak> and re-open 
// Returns:	
//    success (true / false ) 
//*****************************************************************************
bool CFileLog::InitLog(const char *file_name, int max_size) {
	 str_storestring(&m_LogFileName , file_name);
	 m_MaxSize = max_size;	
  return  OpenLogFile();
}  //	End of InitLog()

//////////////////////////////////////////////////////////////////////
// Private methods
//////////////////////////////////////////////////////////////////////
//*****************************************************************************
// Purpose	: 
//    open a new file if current size is bigger than m_logMaxSize lines
// Parameters:	
//    none
// Returns:	
//    none
//*****************************************************************************
void CFileLog::CheckFileSize() {
    if ( m_CurrentSize >= m_MaxSize ){
         CloseLogFile();
         char bkgname[_MAX_PATH]; 
         snprintf(bkgname,sizeof(bkgname),"%s.bak",m_LogFileName);

	     remove(bkgname);

         // rename the file
	     int rc = rename(m_LogFileName, bkgname);
	     if ( rc ) {
		    // if Error, just remove!
		    remove(m_LogFileName);
         } 
         OpenLogFile();
    } // if size is too big
}  //	End of CheckFileSize()

//*****************************************************************************
// Purpose	: 
//    Open a log file
// Parameters:	
//    none
// Returns:	
//    success (true / false ) 
//*****************************************************************************
bool CFileLog::OpenLogFile() {
    CloseLogFile();
    if ( 0 == 
            ( m_hFile = fopen(m_LogFileName,"w") ) 
            ) {
        printf("\nError opening file %s", m_LogFileName);
        return false;
    } // if fopen
    fprintf(m_hFile,"--- %s log file ----", BINARY_VERSION_STRING);
    m_CurrentSize = 0;
    
	return true;
}  //	End of OpenLogFile()
// MSC2005, ugnore unsafe fopen warning

//*****************************************************************************
// Purpose	: 
//    close file
// Parameters:	
//    none
// Returns:	
//    success (true / false ) 
//*****************************************************************************
bool CFileLog::CloseLogFile() {
    if(m_hFile != 0) {
        fclose(m_hFile);
        m_hFile = 0;
    } // m_hFile
	return true;
}  //	End of CloseLogFile()
