/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* DIALOGIC CONFIDENTIAL
*
* Copyright (C) 2006-2007 Dialogic Corporation. All Rights Reserved.
* The source code contained or described herein and all documents related
* to the source code ("Material") are owned by Dialogic Corporation or its
* suppliers or licensors. Title to the Material remains with Dialogic Corporation
* or its suppliers and licensors. The Material contains trade secrets and
* proprietary and confidential information of Dialogic or its suppliers and
* licensors. The Material is protected by worldwide copyright and trade secret
* laws and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted, distributed,
* or disclosed in any way without Dialogic's prior express written permission.
*
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
//***********************************************************************
//***********************************************************************

// GenLog.h: 
//  interface for the CGenLog class.
//             abstract log setver definitions
//
//  interface for the CanLog class.
//             abstract log client definitions
// 
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_GENLOG_H__E4F54279_EB49_43F7_9534_13E0FAA7C9E7__INCLUDED_)
#define AFX_GENLOG_H__E4F54279_EB49_43F7_9534_13E0FAA7C9E7__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000


// Verbosty levels
typedef enum { 
     LOG_DBG = 0,   // Info/Debug message
     LOG_API,       // Intel-Dialogic API
     LOG_EVT,       // Intel-Dialogic Event
     LOG_APP,       // Application flow
     LOG_WARNING,   // Warning    
     LOG_ERR1,      // Error
     LOG_ERR2,      // Fatal Intel-Dialogic error - can' recover. Terminate application
     LOG_ASSERT,    // Fatal error - Indicates demo program failure. Terminate grecefully
     LOG_ALL,       // For internal use - log anyways
     LOG_NONE,      // Set this verbosity to skip logging
   MSG_TYPE_MAX
}MSG_TYPE; 

// Macro to select verbosity by return code (rc)
//
#define RC(rc) ((rc == 0)?LOG_API:LOG_ERR1)
#define RCEVENT(event) (evt_isfailure(event)?LOG_ERR1:LOG_EVT)

#define RCFATAL(rc) ((rc == 0)?LOG_API:LOG_ERR2)
#define RCHANDLE(rc) ((rc != INV_SRL_HANDLE)?LOG_API:LOG_ERR1)
#define INFORC(rc) ((rc == 0)?LOG_DBG:LOG_ERR1)

/////////////////////////////
// Global functions
//
// return string name for given MSG_TYPE
const char *log_get_msgtype_name(MSG_TYPE msg_type);

// return MSGTYPE value for given string (MSG_TYPE_MAX if not found)
MSG_TYPE log_get_msgtype_value(const char *value_name);

//////////////////


//
// Abstract definition of Log server
//
typedef class CGenLog * PGenLog;

class CGenLog  {

////////////////////////
// Construction/Destcuction

 public:
	CGenLog();
	virtual ~CGenLog();

///////////////////////////
// THE LOGGING FUNCTION
 public:
	bool Log( MSG_TYPE type,             // ERR1, DBG, etc.
              const char * source,       // such as dxxxB1C1, GC etc.
              const char * format,...);  // format and parameters

///////////////////////////
// Abstract interface
 private:
    // provide device specific function to log messages
    virtual bool doLog(MSG_TYPE msg_type, const char *message) = 0;


//////////////////////////
// Verbosity level
//
 public:
    // Check verbosity level
    // Return false if message should be skipped 
    bool CanOutput(MSG_TYPE type){
        return type >= m_verbosity;
    }

    // Check all verbosity levels 
    // return false if message will be skipped from all chained logs
    // used to skip sprintf and other log preparations
    // if they aren't necessary
    bool WillLog(MSG_TYPE msg_type){
        if (CanOutput(msg_type) ){
            return true;
        }
        if (m_pNextLog){
            return m_pNextLog->WillLog(msg_type);
        }
        return false;
    }

    // set verbosity level
    void SetVerbosity(MSG_TYPE min_type){
        m_verbosity = min_type;
    }
 private:
    MSG_TYPE m_verbosity;          // verbosity level for this log


////////////////////////////
// Chained logs
//
// define chain log
// (ex: log in file and console )
 public:
    bool DefineChainLog(CGenLog *pNextLog = 0);

    // Return chained log
    CGenLog *GetChainedLog(){
        return m_pNextLog;
    }

    // unlink chained log w/o deletting it
    void UnlinkChainedLog(){
        m_pNextLog = 0;
    }

    void UnlinkChainedLog(CGenLog *log){
        CGenLog * tmp = m_pNextLog;
        while (tmp) {
            if (tmp == log) {
                m_pNextLog = 0;
                return;
            }
            tmp = tmp->m_pNextLog;
        }
    }
    // delete chained log object
    void DeleteNextLog(){
      // delete does not fail if 0 pointer is passed 
       delete m_pNextLog;
       m_pNextLog = 0;
    }

 private:
    CGenLog *m_pNextLog;           // next chained log


//////////////////////
// Number of log messages
//
 public:
    // returns number of log messages processed so far
    size_t GetNumLogs(){
         return m_num_log_records;
    } 

 private:
    size_t m_num_log_records;      // number of log records so far

    
//////////////////////
// Dump members
//

 public: 
    void Dump(CGenLog *pLog = 0);

//////////////////////
// Keep exit reason
//
 private:
    list<char *> m_FatalMessages;  // keep reasons for exit 
}; // class CGenLog

////////////////////////////////////////////////////////////
//    Abstract definition of log client
////////////////////////////////////////////////////////////
// Log client is an object that can hold a pointer to log server
// Macro LOG us used from clients to send log messages.
// The object that owns client may set/change log server using SetLog()
class CanLog {
 public:
   // Log server should be provided when constructing this object
   CanLog(CGenLog * pLogServer) 
        : m_pLocalLog(pLogServer) {
   };

   virtual ~CanLog(){
   };

   // Specify log server
   void SetLog(CGenLog * pLogServer){
        m_pLocalLog = pLogServer;
   };

   // return current log server
   CGenLog *GetLog(){
       return m_pLocalLog;
   }

 protected:
   // keep here log  server addr.
   CGenLog * m_pLocalLog;
}; // clas CanLog

// Use this macro for local logging
#define LOG m_pLocalLog->Log

#endif // !defined(AFX_GENLOG_H__E4F54279_EB49_43F7_9534_13E0FAA7C9E7__INCLUDED_)
