/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* DIALOGIC CONFIDENTIAL
*
* Copyright (C) 2006-2007 Dialogic Corporation. All Rights Reserved.
* The source code contained or described herein and all documents related
* to the source code ("Material") are owned by Dialogic Corporation or its
* suppliers or licensors. Title to the Material remains with Dialogic Corporation
* or its suppliers and licensors. The Material contains trade secrets and
* proprietary and confidential information of Dialogic or its suppliers and
* licensors. The Material is protected by worldwide copyright and trade secret
* laws and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted, distributed,
* or disclosed in any way without Dialogic's prior express written permission.
*
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
//***********************************************************************
//***********************************************************************
// IptDevice.cpp: implementation of the CIptDevice class.
//
//////////////////////////////////////////////////////////////////////

#include "pdl.h"


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////
//*****************************************************************************
// Purpose	: 
//    Constructor
// Parameters:	
//    Configuration parameters ( from configuration file )
// Returns:	
//    none
//*****************************************************************************
CPstnDevice::CPstnDevice(PCommonParams pCommonParams,
                         PDtiParams pDtiParams ) 
                       : CNtwkDevice(DEV_DTI, pCommonParams, 0) { 

    m_pDtiParams = pDtiParams;
    if (EXIT_OK == GetExitCode()){
       if (! OpenPrivateLog(m_pDtiParams->m_private_log) ){
             SetExitCode(EXIT_LOG);
       }

       if ( EXIT_OK == GetExitCode() ){
             // dx_open etc. 
           if (!open_dx()){
               SetExitCode(EXIT_INIT);
           }
       }

       if ( EXIT_OK == GetExitCode() ){
             // gc_open  etc. 
           if (! Open() ){
               SetExitCode(EXIT_INIT);
           }
       }

    }


 return;
} // End of Constructor()

//*****************************************************************************
// Purpose	: 
//    Destructor
// Parameters:	
//    none
// Returns:	
//    none
//*****************************************************************************
CPstnDevice::~CPstnDevice() {

    
 return;
} // End of Destructor()

//*****************************************************************************
// Purpose	: 
//    OnNewCall():    virtual Hook to handle specific cleanup and init for new call
// Parameters:	
//    none
// Returns:	
//    true = success
//    false = failure
//*****************************************************************************
bool CPstnDevice::OnNewCall() {
   LOG(LOG_APP, GetName(), "Ready to answer PSTN calls");
   return true;
}; // End of OnNewCall()

//*****************************************************************************
// Purpose	: 
//    OnInitComplete: virtual Hook to handle specific one-time initialization
// Parameters:	
//    none
// Returns:	
//    true = success
//    false = failure
//*****************************************************************************
bool CPstnDevice::OnInitComplete() {
     return true;
}; // End of OnInitComplete()


//*****************************************************************************
// Purpose	: 
//    Open device
// Parameters:	
//    none
// Returns:	
//    true = success
//*****************************************************************************
bool CPstnDevice::Open(){
 bool brc = false;
 int rc;
 if (IsSrlState(SRLSTATE_VOICEOPENED, true) ) {
     if ( IsSrlState(SRLSTATE_RESERVED, true)  ) { 
          char gc_name[200];
          snprintf(gc_name, sizeof(gc_name), ":N_%s:P_%s",
                            GetName(), "ISDN" );
          rc = gc_OpenEx(&m_srl_handle, gc_name,EV_ASYNC, this);
          LOG( RC(rc), GetName(),
               "%d = gc_OpenEx(hndl := 0x%x, %s, EV_ASYNC,0x%x(this)",
               rc, m_srl_handle, gc_name, this);

          if ( rc == GC_SUCCESS){
               brc = true ;
               SetCurrentState(S_OPEN);
               SetSrlState(SRLSTATE_OPENED);
               StartTimer();
               LOG(LOG_DBG,GetName(),"***Start timer for %d ms", GetDfltTimer());
          }else {
               process_gc_error();
               SetCurrentState(S_FINAL);
          }
     } // IsSrlState reserved
     else {
           LOG( LOG_ERR1, GetName(),
                "gc_Open(): (board) - device not reserved");
     } 
 }
 if (!brc){     
     SetSrlState(SRLSTATE_FAILED_FATAL);
 }

 return brc;
} // End of Open()

//*****************************************************************************
// Purpose	: 
//    Handle events
// Parameters:	
//   [in] event
//   [in] event data
//   [in] data length
//   [in] METAEVENT (not used)
// Returns:	
//    none
//*****************************************************************************
void CPstnDevice::HandleEvent(int event,
                             void *evtdata, int evtlen,
                             METAEVENT *metaeventp){

    CNtwkDevice::HandleEvent(event, evtdata, evtlen, metaeventp);

    switch (event){
        case GCEV_OPENEX:
            // Permanent setup
            // Get Network handle ( GC_MEDIADEVICE or GC_NETWORKDEVICE
             GetPstnResourceHandle();
             break;
        default:
             break;
    } // switch (event)
   
 return ;
} // End of HandleEvent()


//*****************************************************************************
// Purpose	: 
//     Get Network handle ( GC_NETWORKDEVICE ) and store for future use
// Parameters:	
//    none
// Returns:	
//    true = success
//*****************************************************************************
bool CPstnDevice::GetPstnResourceHandle(){
  bool brc = true;
  int rc =  gc_GetResourceH(m_srl_handle, (int *)&m_ntwk_srl_handle, GC_NETWORKDEVICE);
        LOG( RC(rc), GetName(),
             "%d = gc_GetResourceH (hndl = 0x%x, ipml_hndl := 0x%x, GC_NETWORKDEVICE)",
             rc, m_srl_handle, m_ntwk_srl_handle );
        
        if (rc != GC_SUCCESS) {
            brc = false;
            process_gc_error();
        }
  return brc;
} // End of GetPstnResourceHandle()
