/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* DIALOGIC CONFIDENTIAL
*
* Copyright (C) 2006-2007 Dialogic Corporation. All Rights Reserved.
* The source code contained or described herein and all documents related
* to the source code ("Material") are owned by Dialogic Corporation or its
* suppliers or licensors. Title to the Material remains with Dialogic Corporation
* or its suppliers and licensors. The Material contains trade secrets and
* proprietary and confidential information of Dialogic or its suppliers and
* licensors. The Material is protected by worldwide copyright and trade secret
* laws and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted, distributed,
* or disclosed in any way without Dialogic's prior express written permission.
*
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
//***********************************************************************
//***********************************************************************
// StateMachine.cpp: implementation of the CStateMachine class.
//
//////////////////////////////////////////////////////////////////////

#include "pdl.h"
#include "SdpParser.h"

static const char * SDP_MODULE_NAME = "SdpParser";


static NAME_TABLE sdp_table[] = {
	{ "m", SDP_CMD_M },
	{ "i", SDP_CMD_I },
	{ "c", SDP_CMD_C },
	{ "b", SDP_CMD_B },
	{ "k", SDP_CMD_K },
	{ "a", SDP_CMD_A },
	{ "t", SDP_CMD_T },
	{ "r", SDP_CMD_R },
	{ "z", SDP_CMD_Z },

	{ "v", SDP_CMD_V },
	{ "o", SDP_CMD_O },
	{ "s", SDP_CMD_S },
	{ "u", SDP_CMD_U },
	{ "e", SDP_CMD_E },
	{ "p", SDP_CMD_P },
	{ 0  , 0 },
};


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////
//*****************************************************************************
// Purpose	: 
//    Constructor
// Parameters:	
//    none
// Returns:	none
//*****************************************************************************
CSdpParser::CSdpParser(CGenLog *pLog):
            CParser(pLog),
			m_MediaInfo(pLog),
            m_CmdParser(pLog) {
	sdp_o = 0;	// owner/creator
	sdp_s = 0;  // session name
	sdp_a = 0;	// session level attributes
	sdp_u = 0;	// url
	sdp_e = 0;	// email
	sdp_p = 0;	// phone
	sdp_z = 0;	// time zone
	sdp_r = 0;	// time zone

	sdp_tstart=0;
	sdp_tstop = 0;
  clear_vars();
}  //	End of constructor()

//*****************************************************************************
// Purpose	: 
//    Destructor
// Parameters:	
//    none
// Returns:	none
//*****************************************************************************
CSdpParser::~CSdpParser(){
	 clear_vars();
 return;
}//	End of destructor()

//*****************************************************************************
// Purpose	: 
//     Clear internal variables
// Parameters:	
//     None
// Returns:	
//     none
//*****************************************************************************
void CSdpParser::clear_vars(){
  sdp_v = 0;
  str_deletestoredstring(&sdp_o);
  str_deletestoredstring(&sdp_s);
  str_deletestoredstring(&sdp_a);
  str_deletestoredstring(&sdp_u);
  str_deletestoredstring(&sdp_e);
  str_deletestoredstring(&sdp_p);
  str_deletestoredstring(&sdp_z);
  str_deletestoredstring(&sdp_r);

  m_MediaInfo.clear_vars();
  LOG(LOG_DBG, SDP_MODULE_NAME, "ClearVars");
}

//*****************************************************************************
// Purpose	: 
//     skip following '='
// Parameters:	
//     None
// Returns:	
//     success
//***************************************************************************** 
bool CSdpParser::skip_equal(const char *cmd){
  char token[MAXTOKEN];
  if ( ! GetNextToken(token,sizeof(token) )  || 
		( 0 != str_compare(token,"="))    ){
		LOG(LOG_WARNING, SDP_MODULE_NAME,"incomplete sdp descriptor '%s[missing '=']",cmd);
		back();
		return false;
  }
  return true;
}
static NAME_TABLE ipv_addr[] = {
	{"IP4", ADDR_IP4 },
	{"IP6", ADDR_IP6 },
	{ 0,0 }
};
//*****************************************************************************
// Purpose	: 
//     Process command m=
// Parameters:	
//     none
// Returns:	
//     state (STATE_BGN, STATE_MEDIA or STATE_SKIP_MEDIA
//*****************************************************************************
//static NAME_TABLE payload_names[] = {
//    {   "0",        CODER_TYPE_G711ALAW64K },  // GSM
//    {   "9",        CODER_TYPE_G722_48K },     // GSM
//}

//CMediaInfo

P_STATE CnfDemoMediaInfo::ProcessMediaCommand(const char *cmd){
  char token[MAXTOKEN];
  m_CmdParser.SetBuffer(cmd);
    // audio/video/application/data/control
    if (! m_CmdParser.GetNextToken(token,sizeof(token)) ){
	    LOG(LOG_WARNING, SDP_MODULE_NAME, "Invalid command m=[missing media type]");
        return STATE_SKIP_MEDIA;
    }

    if ( 0 != str_compare(token, "audio") ){
	     LOG(LOG_WARNING, SDP_MODULE_NAME, "Unsupported media type %s in command m=(only audio is supported)]", token);
         return  STATE_SKIP_MEDIA;
    }  

    // port 
    if (!m_CmdParser.GetNextToken(token,sizeof(token)) ){
	     LOG(LOG_WARNING, SDP_MODULE_NAME, "Invalid command m=[missing port]");
         return  STATE_SKIP_MEDIA;
    }

    m_CmdParser.GetUNumber(token,&m_remote_port);
    LOG(LOG_DBG, SDP_MODULE_NAME, "remote_port = %d, token = %s", m_remote_port,token);

    // RTP/RTCP
    if (!m_CmdParser.GetNextToken(token,sizeof(token)) ){
	     LOG(LOG_WARNING, SDP_MODULE_NAME, "Invalid command m=[transport]");
         return  STATE_SKIP_MEDIA;
    }

    // Payload (3 (payload type) 97 98 8 0 101)
    // 3: GSM 8000
    // 4:  // Payload is assumed to be whatever is specified in cfg file,
    //    this value is ignored
    

 return STATE_MEDIA;
}
//*****************************************************************************
// Purpose	: 
//     Parse 'c' line
// Parameters:	
//     Parser
// Returns:	
//     none
//*****************************************************************************
bool CnfDemoMediaInfo::Parse_c_line(CSdpParser *pSdpParser ){
char line[MAXTOKEN];
bool brc = false;
   if ( pSdpParser->GetLine(line, sizeof(line)) ){
        str_storestring(&sdp_c, line);
        m_CmdParser.SetBuffer(line);
	    char token[MAXTOKEN];

		// c=IN
		if (! m_CmdParser.GetNextToken(token, sizeof(token)) ){
		      LOG(LOG_WARNING, SDP_MODULE_NAME, "Invalid command c=[missing value]");
              return brc;
        }

		if ( 0 != str_compare(token,"IN")){
		     LOG(LOG_WARNING, SDP_MODULE_NAME, "Invalid command c=[missing IN]");
             return brc;
        }

		// c=IN IP4 ot IP6
		if (! m_CmdParser.GetNextToken(token, sizeof(token)) ){
		      LOG(LOG_WARNING, SDP_MODULE_NAME, "Invalid command c=IN [missing IP4 or IP6]");
              return brc;
        }

		// IP
		if (! m_CmdParser.GetNextToken(sdp_remote_ip, sizeof(sdp_remote_ip)) ){
		      LOG(LOG_WARNING, SDP_MODULE_NAME, "Invalid command c=IN %s [missing ip addr]", token);
              return brc;
        }

		if ( !str_findcode(token,(int *)&sdp_remote_ip_version,ipv_addr) ){
		      LOG(LOG_WARNING, SDP_MODULE_NAME, "Invalid command c=IN [expected IP4 or IP6, found %s]", token);
              return brc;
        }

		if ( sdp_remote_ip_version != ADDR_IP4 ) {
		     LOG(LOG_WARNING, SDP_MODULE_NAME, "Command c= : Only IP4 IP addr is supported in this demo");
		     return brc;
        }
   }    brc = true;
 return brc;
}
//*****************************************************************************
// Purpose	: 
//     Parse Media data lines data from sdp message
// Parameters:	
//     sdp message
// Returns:	
//     none
//*****************************************************************************
bool CnfDemoMediaInfo::ParseMediaDataLines(int sdp_cmd, CSdpParser *pSdpParser ){
  // only m,i,c,b,k,a commands are accepted in both states
  char token[MAXTOKEN];
  bool brc = true; // processed 
  switch(sdp_cmd){
     // i=My session descriptor is a text line
  	  case SDP_CMD_I:
		   if (pSdpParser->GetLine(token, sizeof(token)) ){
				 str_storestring(&sdp_i, token);
		   }
		   break;

	  // bandwith ... ( not really supported )
	   case SDP_CMD_B:
	  	    if (pSdpParser->GetLine(token, sizeof(token)) ){
		 	    str_storestring(&sdp_b, token);
			}
			break;

			// attributes
	   case SDP_CMD_A:
			if (pSdpParser->GetLine(token, sizeof(token)) ){
			    str_storestring(&sdp_a, token);
            } 
			break;

      // encryption key - not supported
	   case SDP_CMD_K:
			if ( pSdpParser->GetLine(token, sizeof(token)) ){
				str_storestring(&sdp_k, token);
            }
			break;

          // Connection
       case SDP_CMD_C:
            Parse_c_line(pSdpParser);
            break;

       default:
           brc = false;
  } // swithc
 return brc;
}

//*****************************************************************************
// Purpose	: 
//     Parse session data lines
// Parameters:	
//     sdp message
// Returns:	
//     none
//*****************************************************************************
bool CSdpParser::ParseSessionDataLines(SDP_CMD sdp_cmd) {
bool brc = true;
char token[MAXTOKEN];

  switch(sdp_cmd){
  // v=0 (version is a number)
	case SDP_CMD_V:			// version
	   	 if ( ! GetNextToken(token,sizeof(token) ) ) {
			  LOG(LOG_WARNING, SDP_MODULE_NAME,"incomplete sdp descriptor 'v[missing value]");
		 } else {
			 if (!GetUNumber(token,&sdp_v)){
				  LOG(LOG_WARNING, SDP_MODULE_NAME,"invalid value: v=%s",token);
			 } 
         } 
		 break;

  // o=owner of the session is a text line
	case SDP_CMD_O:
		 if ( GetLine(token, sizeof(token)) ){
			  str_storestring(&sdp_o, token);
		 }
		 break;
				
  // s=session name is a text line
	case SDP_CMD_S:
		 if ( GetLine(token, sizeof(token)) ){
			  str_storestring(&sdp_s, token);
         }
		 break;

  // session level attributes
	case SDP_CMD_A:
		 if ( GetLine(token, sizeof(token)) ){
			  str_storestring(&sdp_a, token);
		 }
		 break;

  // t= start stop - 2 numbers
	case SDP_CMD_T:
		 if ( ! GetNextToken(token,sizeof(token) ) ) {
			  LOG(LOG_WARNING, SDP_MODULE_NAME,"incomplete sdp descriptor 't[missing value]");
		 } else if (!GetUNumber(token,&sdp_tstart)){
			  LOG(LOG_WARNING, SDP_MODULE_NAME,"invalid value: t=%s",token);
		 } else  if ( ! GetNextToken(token,sizeof(token) ) ) {
					  LOG(LOG_WARNING, SDP_MODULE_NAME,"incomplete sdp descriptor 't[missing second value]");
		 } else if (!GetUNumber(token,&sdp_tstop)){
 			  LOG(LOG_WARNING, SDP_MODULE_NAME,"invalid second value %s: expected  t=num num", token);
		 } 
		 break;

	// phone number
	case SDP_CMD_P:
		 if ( GetLine(token, sizeof(token)) ){
			  str_storestring(&sdp_p, token);
		 }
		 break;

	// email
	case SDP_CMD_E:
		 if ( GetLine(token, sizeof(token)) ){
			  str_storestring(&sdp_e, token);
		 }
		 break;

	// z number -1h  number 0 ... ( not really supported )
	case SDP_CMD_Z:
		 if ( GetLine(token, sizeof(token)) ){
			  str_storestring(&sdp_z, token);
		 }
		 break;

	// r repeat times (not supported)
	case SDP_CMD_R:
		 if ( GetLine(token, sizeof(token)) ){
			  str_storestring(&sdp_r, token);
		 }
		 break;

	case SDP_CMD_U:
		 if ( GetLine(token, sizeof(token)) ){
			  str_storestring(&sdp_u, token);
		 }
		 break;

      // Connection
    case SDP_CMD_C:
         m_MediaInfo.Parse_c_line(this);
		 break;

	default:
        { const char *sdp_cmd_name ;
            str_findname(sdp_cmd,&sdp_cmd_name,sdp_table);
		    LOG(LOG_ERR1, SDP_MODULE_NAME,"App error: invalid command code/missing switch case %d '%s'",
                 sdp_cmd, sdp_cmd_name);
        }
         brc = false;
		 break;
  } // switch
 return brc;
}

//*****************************************************************************
// Purpose	: 
//     Extract data from sdp message
// Parameters:	
//     sdp message
// Returns:	
//     none
//*****************************************************************************
bool CSdpParser::ParseSdpOffer(){
  char token[MAXTOKEN];
  SDP_CMD sdp_cmd;

  LOG(LOG_DBG, SDP_MODULE_NAME,"Enter ParseSdpOffer()");

  clear_vars();
  unsigned int line = GetCurrentLineNumber();
  P_STATE state = STATE_BGN;
  CnfDemoMediaInfo *pMediaInfo = &m_MediaInfo;


  while ( GetNextToken(token,sizeof(token) ) ) {
	  if (!str_findcode(token,(int *)&sdp_cmd,sdp_table)){
		   LOG(LOG_WARNING, SDP_MODULE_NAME,"unknown sdp descriptor '%s'",token);
	  }else if (skip_equal(token)){
		  if (sdp_cmd == SDP_CMD_M ) {
			  // Media command
			  if ( GetLine(token, sizeof(token)) ){
				   str_storestring(&pMediaInfo->sdp_m, token);
				   LOG(LOG_DBG,SDP_MODULE_NAME,"m=%s",pMediaInfo->sdp_m);
              }
              state = pMediaInfo->ProcessMediaCommand(token);
          }else {
			  switch (state) {
				  case STATE_BGN:
					   ParseSessionDataLines(sdp_cmd);
                       break;

				  case STATE_MEDIA:
                       if (! pMediaInfo->ParseMediaDataLines(sdp_cmd, this)  ){
                             LOG(LOG_WARNING, SDP_MODULE_NAME, "Command %s= is not valid after command m=", token);
                       }
                       break;
					  
				  case STATE_SKIP_MEDIA:
        			   LOG(LOG_WARNING, SDP_MODULE_NAME, "Command %s= is skipped(media not supported", token);
              }// switch state
		  }// not cmd_m ends
      } // else (skip_equal)

	  // skip rest of the same line
	  if (GetCurrentLineNumber() == line ){
		  if (! GotoNextLine() ){
			  break;
		  }
	  }	
	  line = GetCurrentLineNumber();
  } // while
  return true;
}

//*****************************************************************************
// Purpose	: 
//     Dump sdp variables
// Parameters:	
//     sdp message
// Returns:	
//     none CHECKNULL
//*****************************************************************************
void CnfDemoMediaInfo::Dump(void){
   LOG(LOG_DBG,SDP_MODULE_NAME, "media         m=%s", CHECKNULL(sdp_m));
   LOG(LOG_DBG,SDP_MODULE_NAME, "  Information i=%s", CHECKNULL(sdp_i));
   LOG(LOG_DBG,SDP_MODULE_NAME, "  Encryption  k=%s", CHECKNULL(sdp_k));
   LOG(LOG_DBG,SDP_MODULE_NAME, "  Bandwith    b=%s", CHECKNULL(sdp_b));
   LOG(LOG_DBG,SDP_MODULE_NAME, "  Attributes  a=%s", CHECKNULL(sdp_a));

    if(sdp_c){
		const char *ip_name;
		str_findname(sdp_remote_ip_version, &ip_name,ipv_addr);
		      LOG(LOG_DBG,SDP_MODULE_NAME, "conn info   c=%s",	 sdp_c);
			  LOG(LOG_DBG,SDP_MODULE_NAME, "               ip  = %s", sdp_remote_ip);
			  LOG(LOG_DBG,SDP_MODULE_NAME, "               ipv = %d %s", sdp_remote_ip_version, ip_name);
	}
	          LOG(LOG_DBG,SDP_MODULE_NAME, "remote port        = %d 0x%x%",	m_remote_port, m_remote_port);

 return;
}
//*****************************************************************************
// Purpose	: 
//     Dump sdp variables
// Parameters:	
//     sdp message
// Returns:	
//     none
//*****************************************************************************
void CSdpParser::Dump(void){
     LOG(LOG_DBG,SDP_MODULE_NAME, "Version     v=%d", sdp_v);
	 LOG(LOG_DBG,SDP_MODULE_NAME, "Owner       o=%s", CHECKNULL(sdp_o));
	 LOG(LOG_DBG,SDP_MODULE_NAME, "Session     s=%s", CHECKNULL(sdp_s));
	 LOG(LOG_DBG,SDP_MODULE_NAME, "attrubute(s)a=%s", CHECKNULL(sdp_a));
	 LOG(LOG_DBG,SDP_MODULE_NAME, "URL         u=%s", CHECKNULL(sdp_u));
	 LOG(LOG_DBG,SDP_MODULE_NAME, "email       e=%s", CHECKNULL(sdp_e));
	 LOG(LOG_DBG,SDP_MODULE_NAME, "phone       p=%s", CHECKNULL(sdp_p));
     LOG(LOG_DBG,SDP_MODULE_NAME, "time        t=%d %d", sdp_tstart, sdp_tstop);
	 LOG(LOG_DBG,SDP_MODULE_NAME, "time zone   z=%s", CHECKNULL(sdp_z));
	 LOG(LOG_DBG,SDP_MODULE_NAME, "repeat time z=%s", CHECKNULL(sdp_r));
	 LOG(LOG_DBG,SDP_MODULE_NAME, "url         u=%s", CHECKNULL(sdp_u));
   m_MediaInfo.Dump();
 return;
}
