/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* DIALOGIC CONFIDENTIAL
*
* Copyright (C) 2006-2007 Dialogic Corporation. All Rights Reserved.
* The source code contained or described herein and all documents related
* to the source code ("Material") are owned by Dialogic Corporation or its
* suppliers or licensors. Title to the Material remains with Dialogic Corporation
* or its suppliers and licensors. The Material contains trade secrets and
* proprietary and confidential information of Dialogic or its suppliers and
* licensors. The Material is protected by worldwide copyright and trade secret
* laws and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted, distributed,
* or disclosed in any way without Dialogic's prior express written permission.
*
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
//***********************************************************************
//***********************************************************************
// CSrlThread.h: interface for the CSrlThread class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_SRLTHREAD_H__CC636419_19FE_40C5_B8F3_169025E4C405__INCLUDED_)
#define AFX_SRLTHREAD_H__CC636419_19FE_40C5_B8F3_169025E4C405__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

//
// Globals:
// determine if given event is a notification
bool evt_isnotification(int event);
// determine if given event indicates a failure
bool evt_isfailure(int event);
// determine if given event is defined in this demo
bool evt_isuser(int event);
//    determine if given event is significant for changing state in normal flow
bool evt_issignificant(int event);


// Get event name by code
bool evt_getname(int event, const char **name);

typedef class CSrlThread * PSrlThread;

//
// SrlThread is a container for all srl devices that it serves
// Can run in separate thread (threading functions are not included )
// Can run in main thread when is in polled mode
//

class CSrlThread : public CSrlDeviceContainer{
public:
	CSrlThread(PCommonParams pCommonParams);
	virtual ~CSrlThread();

    virtual bool Execute(int action) {
		UNREFERENCED_PARAMETER(action);
        return true;
    }

    // Initialisate timeout and mode
    bool InitMode(int tmo, int mode);

    // Call this inside Srl thread body
    // Wait for events and run all state machines
    void TheThreadBody();

    // An alternative for TheThreadBody
    // Run state machines until all devices reach desired state or until tmo(sec)
    bool WaitSrlState(int tmo, int srl_state, bool compare_flag, PSrlDevice *ppDev);

    // indicated if all channels are closed and in idle state
    // ready for app exit
    bool IsReadyToExit();

    // Exiting
public:
    void SignalExitRequest(){
         flag_exit_request = true;
    }

private:
    bool flag_exit_request;


private:
    void OnIdle();                   // Do something when the system is idle    
    void EventHandler(int evhandle); // Handle event
    int m_srl_tmo;                   // milliseconds to wait for event 
                                     // until timing out. 
    unsigned int m_onidle_counter;   // used in OnIdle()

    list <PSrlDevice> m_DeviceList;  // list of individual SRL devices or Device containers
};// class SrlThread

#endif // !defined(AFX_SRLTHREAD_H__CC636419_19FE_40C5_B8F3_169025E4C405__INCLUDED_)
