/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* DIALOGIC CONFIDENTIAL
*
* Copyright (C) 2006-2007 Dialogic Corporation. All Rights Reserved.
* The source code contained or described herein and all documents related
* to the source code ("Material") are owned by Dialogic Corporation or its
* suppliers or licensors. Title to the Material remains with Dialogic Corporation
* or its suppliers and licensors. The Material contains trade secrets and
* proprietary and confidential information of Dialogic or its suppliers and
* licensors. The Material is protected by worldwide copyright and trade secret
* laws and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted, distributed,
* or disclosed in any way without Dialogic's prior express written permission.
*
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
//***********************************************************************
//***********************************************************************
// win_unix.h: declaration of unix & Linux dependant implementations
//
//////////////////////////////////////////////////////////////////////

#ifndef WIN_UNIX_HEADER
#define WIN_UNIX_HEADER

# ifdef WIN32
  //--------------------------
  //  ------ Windows ---------
  //--------------------------
#   include <Windows.h>
//  msc 2005 VERSION
// _MSC_VER = 1200 for 6.0
// _MSC_VER = 1400 for 8.0
// more reliable versions of sprintf
# if _MSC_VER >= 1400 
#       define snprintf  sprintf_s
#       define vsnprintf _vsnprintf
#    else
#       define snprintf  _snprintf
#       define vsnprintf _vsnprintf
#   endif // _MSC2005

// Polled mode is SR_STASYNC in windows
#      define SRL_POLLED_MODE  SR_STASYNC       

// Thread ID
#      define GETTHREADID  GetCurrentThreadId

  //-------------------------------
  //  ------ End Windows ---------
  //-------------------------------

#   else // if defined LINUX?
  //------------------------
  //  ------ Linux ---------
  //------------------------
#   include <unistd.h>
#   ifndef UNREFERENCED_PARAMETER
#       define UNREFERENCED_PARAMETER(p)
#   endif
//  Sleep is windows specific function,
//  Linux implementation is in utils.c
       void Sleep(unsigned long milliseconds);

//   Polled mode is SR_POLLMODE in Linux :(
#      define SRL_POLLED_MODE  SR_POLLMODE       

// Some windows specific constants are not defined in Linux
#      ifndef _MAX_PATH
#          define _MAX_PATH 256
#      endif
#      ifndef O_BINARY
#          define O_BINARY 0
#      endif

// dx_fileopen and dx_fileclose exist only for win32 
#      define dx_fileopen open
#      define dx_fileclose close 

// Thread ID
#      define GETTHREADID  pthread_self


  //----------------------------
  //  ------ End Linux ---------
  //----------------------------
# endif // not Win32 (implies Linux)


#endif //WIN_UNIX_HEADER
