//***********************************************************************
// Copyright  2005, Intel Corporation. 
// All rights reserved All names, products, and services mentioned  
// herein are the trademarks or registered trademarks of their respective 
// organizations and are the sole property of their respective owners
//***********************************************************************
// AppLog.h: interface for the CAppLog class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(APPLOG_H)
#define APPLOG_H

#if defined(_WIN32)
#include <windows.h>
#endif

//FILE *invalid_file_handle = NULL ;
#ifndef INVALID_HANDLE_VALUE
#define INVALID_HANDLE_VALUE (-1)
#endif

class CAppLog
{
public:
	CAppLog();
	virtual ~CAppLog();

private:
	union 
	{
		char	m_logFileName[256];
		char	m_logFileBuffer[256];
	};
	int		m_logMaxSize;
	int		m_currentSize;
	FILE    *m_logFileHandle;

private:
	
	int		openLogFile();
	int		closeLogFile();
public:
	void addToLog(int type, const char * source, const char * info);
	void initLog(const char * fileName, int maxSize);
};


#endif // !defined(APPLOG_H)
