//***********************************************************************
// Copyright  2005, Intel Corporation. 
// All rights reserved All names, products, and services mentioned  
// herein are the trademarks or registered trademarks of their respective 
// organizations and are the sole property of their respective owners
//***********************************************************************

// Conference.h: interface for the CConference class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(CLASS_CONFERENCE)
#define CLASS_CONFERENCE

#include <list>

struct confParty
{
	int  cp_partId;
	long cp_txTimeSlot;
	int  cp_partChannelNumber;
	int  cp_digitCount;
	bool cp_isRcvOnly;
	char cp_digBuf[2];
};

typedef std::list<confParty*> partyList; // to overcome 255 char's debugger warning

class CConference  
{
public:
	CConference();
	virtual ~CConference();
private:
	int  m_hDsp;
	int  m_confId; // unique internal ID
	int	 m_bridgeNumber; // bridge number fron config file

	partyList m_partyList; // linked list contains all participants in this conference 
	
	bool m_isEchoCancelEnabled;
	bool m_isDtmfEnabled;
	
	bool   m_isMonitorInProgress;
	void * m_monitorObject;
	int	   m_monitorTxTimeslot;	

	char   m_muteDigits[2];	
	
	char m_txt[128];

	void updateConfFeatures(bool echoCanceller, bool dtmfEnabled);
	void setReceiveOnlyMode(confParty * party);

	void logOut(int type, const char * info, int printConsoleNum);
	void checkError(const char * funcName);

public:
	int		processDigit(int txTimeSlot, char digit); // for autoprocessing
// these 2 below for external interface

	int		init(int hDsp);
	void	setConferenceFeatures(bool echoCanceller, bool dtmfEnabledconst,
			     const char* muteDig);
	int		addToConf(int channelNumber, int timeslot_in, int * timeslot_out);
	int		addMonitor(void * monitorObj, int timeslot_in, int * timeslot_out);
	int		removeFromConf(long txTimeSlot);
	void *  removeMonitor();
	int		deleteConference();	
	int		getResourceCount();
	
	confParty * findParticipant(long txTimeSlot, int partyId);

	inline int  getConfId() const { return m_confId; };
	inline void setConfId(int confId) { m_confId = confId; };
	inline int  getBridgeNumber() const { return m_bridgeNumber;};
	inline void setBridgeNumber(int bridgeNum) { m_bridgeNumber = bridgeNum;};
	inline int  getConfDsp() const { return m_hDsp; };
	inline unsigned int getNumberOfParticipants() const { return m_partyList.size();};
};

#endif	// #if !defined(CLASS_CONFERENCE)
