#include "CRTSPEnv.h"
#include "CRTSPClient.h"
#include <boost/bind.hpp>
#include <queue>
#include <iostream>

CRTSPEnv* CRTSPEnv::pInst = NULL;
char CRTSPEnv::watchVariable = '\0';

CRTSPEnv* CRTSPEnv::Instance()
{
	if (pInst == NULL)
	{
		pInst = new CRTSPEnv();
	}
	return pInst;
}

CRTSPEnv::CRTSPEnv() {
   scheduler = BasicTaskScheduler::createNew();
   env = BasicUsageEnvironment::createNew(*scheduler);
   progName.assign("MultiMediaDemo");
   workerThread = new boost::thread(boost::bind(CRTSPEnv::WorkerThreadFcn, this));
}

void CRTSPEnv::WorkerThreadFcn(CRTSPEnv* pEnv) {
   pEnv->watchVariable = '\0';
   while (1) {
      if (pEnv->watchVariable == '\0')
      {
         printf("Event loop enabled\n");
         pEnv->scheduler->doEventLoop(&pEnv->watchVariable);
      }
      else
         usleep(20000);
   }
   printf("Event loop thread exiting\n");
}

void CRTSPEnv::armDroppedConnection(double timer, CRTSPClient* pClient)
{
     watchVariable = '1';
     scheduler->turnOnBackgroundReadHandling(pClient->socketNum(),
        (TaskScheduler::BackgroundHandlerProc*)&incomingRequestHandler, pClient);
     if (timer > 0.0) {
        int uSecsToDelay = (int)(timer*1000000.0);
	scheduler->scheduleDelayedTask(uSecsToDelay, timeoutHandler, this);
     }
     watchVariable = '\0';
}

void CRTSPEnv::incomingRequestHandler(void* clientData, int mask) {
   CRTSPClient* pClient = (CRTSPClient*)clientData;
   CRTSPEnv* pEnv = CRTSPEnv::Instance();
   printf("Client %p got handled\n", pClient);
   watchVariable = '1';
   pClient->SessionTerminated();
   pEnv->scheduler->turnOffBackgroundReadHandling(pClient->socketNum());
   watchVariable = '\0';
}

void CRTSPEnv::timeoutHandler(void* clientData) {
   CRTSPClient* pClient = (CRTSPClient*)clientData;
   pClient->SessionTerminated();
}
