/**
* @file exitsync.h
* @brief Multimedia demo exit synchronization header
* @date Feb 16, 2007
*
* DIALOGIC CONFIDENTIAL 
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to 
* the source code ("Material") are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its 
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced, 
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual 
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#ifndef _exitsync_h
#define _exitsync_h

// Standard Include Files
#ifdef WIN32
    #include <windows.h>
#else
    #include <signal.h>
    #include <semaphore.h>
#endif

#include <iostream>

// Class Declaration 
class CExitSync  {
public:
    // Class Constructor
    CExitSync();

    // Class Destructor
    virtual ~CExitSync();

    // Class Member Functions
    static void BeginExit(void);
    static void ForceExit(void);
    static void WaitExitSignal(void);
    static CExitSync* Instance(void);

#ifdef WIN32
    static int __stdcall CtrlHandler( unsigned long dwCtrlType );
#else
    static void CtrlHandler(int signum);
#endif

private:
    // Class Member Variables
#if defined(WIN32)
    static HANDLE   hExitAppEvent;
#else
    static sem_t    hExitAppEvent;
#endif

    static unsigned exitTry;
    static CExitSync* pInst;
};

#endif 
