/**
* @file ipchannel.h
* @brief Multimedia demo call control header
* @date Feb 16, 2007
*
* DIALOGIC CONFIDENTIAL 
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to 
* the source code ("Material") are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its 
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced, 
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual 
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#ifndef _ipchannel_h
#define _ipchannel_h

// Application Level Include Files
#include "mmstream.h"
#include "locker.h"

// Class Declaration
class CIPChannel {
public:
    // Class Member Variables
    char                    m_devName[DEV_NAME];                // Device Names
    bool                    m_bIsFree;                          // flag that indicates if this object is being used in a Connection
    int                     m_nCount;                           // Variable to keep track of the count
    bool                    m_bCallAttempt;                     // set when Makecall is issued or Offered received, cleared when connected
    int                     m_nConnects;                        // no. of successful calls
    int                     m_nFailedCalls;                     // no. of unsuccessful calls.
    long                    m_gcDev;                            // GC Device Handles
    long                    m_talkTs;                           // CTBus Talk Timeslots
    const char              *m_state_name;                      // name of the current state
    char                    m_cPhoneNum[GCNAME_MAXSIZE];        // phone number to dial
    char                    m_cOriginationNum[GCNAME_MAXSIZE];  // incoming phone number
    char                    m_cProxyIp[GC_ADDRSIZE];            // Gatekeeper or Proxy IP address
    unsigned long           m_nConnectionId;
    static bool             s_bRegistered;//	= FALSE;			 
    static bool             s_bBrdOpened;//	= FALSE;
    static long             s_gcBrdDev;//		= 0;
    static int           s_nRegister_TTL;

    typedef unsigned long   EVENT;
    typedef void            (CIPChannel:: *APPHANDLER)(void *pData);
    enum state_t {
   // Call State Identifiers
        state_initial           = 0,
        state_opened            = 1,
        state_null              = 2,
        state_proceeding        = 3,
        state_offered           = 4,
        state_alerting          = 5,
        state_accepted          = 6,
        state_connected         = 7,
        state_disconnected      = 8,
        state_usrDisconnected   = 9,
        state_idle              = 10,
        state_appStopping       = 11
    };

    struct stateTransition {
   // Call state descriptor 
        EVENT               st_event;
        APPHANDLER          st_action;
        state_t             st_next;
        char                st_name[30];
    };

    static device_type      s_eType;
    static stateTransition  s_openedTable[];
    static stateTransition  s_initialTable[];
    static stateTransition  s_restartingTable[];
    static stateTransition  s_nullTable[];
    static stateTransition  s_offeredTable[];
    static stateTransition  s_acceptedTable[];
    static stateTransition  s_connectedTable[];
    static stateTransition  s_proceedingTable[];
    static stateTransition  s_alertingTable[];
    static stateTransition  s_disconnectedTable[];
    static stateTransition  s_usrDisconnectedTable[];
    static stateTransition  s_idleTable[];
    static stateTransition  s_appStoppingTable[];
    static stateTransition  *s_ipCallTable[];

    CMMStream               *m_pMediaChan;  // MM + IPM channel object

    clock_t                 m_callStart;
    clock_t                 m_callDuration;                     


    // Class Constructor
    CIPChannel(const char *pDevName, char *pDestIp, 
               unsigned long ulConnectionId, CMMStream *pMMChan);

    // Class Destructor
    virtual ~CIPChannel();

    // Class Member Functions
    bool                    Init();
    bool                    Shutdown();
    void                    ReportStats(void* pData);
    void                    SetMetaEvt(METAEVENT& mEvt);
    void                    DropCall(void *pData);
    void                    SetListenFlag(void* pData);
    bool                    Register();
    bool                    DeRegister();
    bool                    process_inbound_sdp(unsigned long sdpType);
    void                    SetState(state_t nextState);
    int                     GetState();
    static  void            ProcessEvent(METAEVENT metaEvt, CIPChannel *pChan);
    void                    GCSetConfigData_EnableEvents();


    // Convenience functions
    void                    mmWaitCall(void* pData);
    void                    mmRestart(void *pData);
    void                    mmListen();
    void                    mmUnlisten(void* pData);
    void                    mmAnswer(void *pData);
    void                    mmAccept(unsigned long sdpType);
    void                    mmDropCall(void *pData);
    void                    mmReleaseCall(void* pData);

private: 
    // Class Member Variables
    bool                    m_bCallInProgress;                  // Indicator for call in progress
    bool                    m_bListening;                       // Indicator for listen complete
    bool                    m_bCallDropped;                     // Indicate that call is already dropped
    char                    m_cDial[GC_ADDRSIZE];               // this phone number
    char                    m_cDnis[GC_ADDRSIZE];               // DNIS [DDI] buffer
    char                    m_cAni[GC_ADDRSIZE];                // ANI [CLI] buffer (Phone Number)
    char                    m_cOrigIP[GC_ADDRSIZE];             // ANI [CLI] buffer (IP Address)
    int                     m_coderCounter;
    state_t                 m_eState;
    CLocker                 m_lock;
    METAEVENT               m_metaEvt;
    CRN                     m_crn;                              // H323 call number for current Event
    CRN                     m_crnForCurrentCall;                // H323 call number for current call
    bool                 m_bIsSDPOffered;              // flag to indicate if we are offered SDP
    sdpSessionDescription m_SDP;

// SKS
		bool		m_bSdpReceived;

    // Class Member Functions
    void                    OnOpenEx(void *pData);                      // Open Event Handler
    void                    OnOffered(void *pData);             // Offered Event Handler
    void                    OnAccept(void* pData);                      // Accept Event Handler
    void                    OnListen(void* pData);                      // Listen Event Handler
    void                    OnExtensionEvent(void *pData);      // Ext Event Handler
    void                    OnGetCallInfo(void *pData);         // incoming call information
    void                    OnAnswered(void* pData);                    // Answered Event Handler
    void                    OnSIPAck(void* pData);                    // SIP Ack Event Handler
    void                    OnConnected(void* pData);                   // Connected Event Handler
    void                    OnUnlisten(void *pData);            // Unlisten Event Handler
    void                    OnDisconnected(void *pData);        // Disconnect Event Handler
    void                    OnRelease(void *pData);             // Release Event Handler
    void                    OnTaskFail(void *pData);            // TaskFail Event Handler
    void                    OnUndeclared(void *pData);          // Undeclared Event Handler
    void                    OnSetConfigData(void *pData);          // SetConfigData Event Handler
    void                    OnError(void *pData);               // Error Event Handler
};

#endif

