/**
* @file miscellaneous.h
* @brief Multimedia demo misc functions header
* @date Feb 16, 2007
*
* DIALOGIC CONFIDENTIAL 
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to 
* the source code ("Material") are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its 
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced, 
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual 
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#ifndef _miscellaneous_h
#define _miscellaneous_h

#pragma warning(disable:4786)

// Standard Include Files
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>
#include <sys/timeb.h>
#include <string>
#include <vector>
#include <queue>
#include <map>
using namespace std;

#ifdef WIN32
    #include <windows.h>
#else
    #include <stdio.h>
    #include <errno.h>
    #include <unistd.h>
    #include <stdarg.h>
    #include <netinet/in.h>
    #include <arpa/inet.h>
    #include <netdb.h>
#endif


// Dialogic Include Files
#include "srllib.h"
#include "gclib.h"
#include "gcip.h"
#include "ipmlib.h"
#include "dxxxlib.h"
#include "devmgmt.h"
#include "mmlib.h"
#include "mmevts.h"
#include "port_connect.h"

// Includes for SDPAPI
#include "sdpAPI.h"
#include "sdpElements.h"
#include "sdpLists.h"
#include "sdpContainers.h"

#include "mtklib.h"
#include "lb_mtklib.h"
#include "ob_mtklib.h"
#include "sm_mtklib.h"
//#include "mc_mtklib.h"


const int   UNDECLARED              = 0x9999;
const int   MAX_CHANS               = 672;
const int   DEV_NAME                = 100;
const int   MAX_VOX_CHANS           = 96;
const int   CHANS_PER_SPAN          = 30;
const int   MAX_SPANS               = 16;
const int   GCNAME_MAXSIZE          = 128;
const int   MAX_SDP_SIZE            = 2048;
const int   MAX_STRING_SIZE         = 1024;
const int   MAX_SDP_LINES           = 100;

enum dtmfMode_e {
    dtmfMode_inband  = 0,
    dtmfMode_rfc2833 = 1,
    dtmfMode_sipinfo = 2,
    dtmfMode_rtc     = 3
};

enum file_format {
	MMD_3GP = 0,
	MMD_DMF	= 1,
	MMD_WAV	= 2
};

// Type of Device
enum device_type {
    NONE            = 0,
    PSTN_DEVICE     = 1,
    IP_DEVICE       = 2,
    IP_BOARD_DEVICE = 3,
    MMS_DEVICE      = 4
};
// mmReport Levels 
enum ReportType {
    INFO_OK         = 0,
    INFO_MSG        = 1,
    INFO_ERROR      = 2,
    ERROR_SYSTEM    = 3,
    ERROR_GCALL     = 4,
    ERROR_IPM       = 5,
    ERROR_DTI       = 6,
    ERROR_VOX       = 7,
    ERROR_SRL       = 8,
    INFO_DEBUG      = 9,
    INFO_DEBUG1     = 10,
    INFO_DEBUG2     = 11
};
// SKS
enum platformName{
	OVL_1_0 = 0,
	HMP_1_5 = 1,
	HMP_3_1 = 2,
	OVL_2_0 = 3,
	ZVL_1_0 = 4,
	HMP_4_1 = 5
};

enum xcodeDir {
	NATIVE = 0,
	RX     = 1,
	TX     = 2,
	RXTX   = 3
};

// SKS	supported audio / video codecs
enum audioCodec {
   NO_AUDIO_CODEC = -1,
   G711    = 0,
   G711U   = 0,
   G723    = 4,
   G711A   = 8,
   G722    = 9,
   G729    = 18,
   AMR     = 96,
   AMRNB   = 96,
   RFCDTMF = 101,
   G726    = 110,
   AMRWB   = 111,
   PCM16K  = 888,
   PCM     = 999
};

enum videoCodec {
   NO_VIDEO_CODEC = -1,
   H263      = 34,
   MPEG4     = 102,
   H264      = 103,
   H263_1998 = 104,
   H263_2000 = 105
};

enum videoResolution {
   SQCIF = 0,
   QCIF  = 1,
   CIF   = 2
};

// Global variables

// Debug Help Menu
static const char *DebugMenu[] =
{                   
    "\n=======================================",
    "Options:\n",
    "0 = Display Summary of Results",
    "1 = Display no. of Successful Calls",
    "2 = Display no. of Unsuccessful Calls",
    "3 = Display each Calls state",
    "4 = Display Call Duration of each call",
    "q = quit the application... wait for shutdown!!!",
    ""
};

// Event Information Structure
typedef struct {
    long evtdev;
    long evtdatalen;
    long evttype;
    void* evtdatap;
    void* extevtdatap;
} srl_event_t;

// Function Declarations
void    mmReport(int iType, int eType, const char *fmt, ...);
const char*   mmEvt2Str(int nEvent);

#endif
