/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* Copyright (C) 2005-2006 Intel Corporation. All Rights Reserved.
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
* 1.      Redistributions of source code must retain the above copyright
* notice, this list of conditions and the following disclaimer.
*
* 2.      Redistributions in binary form must reproduce the above copyright
* notice, this list of conditions and the following disclaimer in
* the documentation and/or other materials provided with the
* distribution.
*
* 3.      Neither the name Intel Corporation nor the names of its contributors
* may be used to endorse or promote products derived from this software
* without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
* ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
* LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
* SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
* CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
* POSSIBILITY OF SUCH DAMAGE.
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/


#include "pdl.h"

int (*cbHandler)();

static long g_SRLDevice;


/*****FUNCTION***************************************************
*        NAME : PDLsr_getboardcnt
* DESCRIPTION : Gets the number of boards in the system
*       INPUT : ipProtocol - the IP protocol name
*               char *name - the class name 
*      OUTPUT : number of boards
*     RETURNS : 0 - success   -1 - fail
*    CAUTIONS : None
****************************************************************/
long PDLsr_getboardcnt(int *boardNum,char *ipProtocol,char *name)
{
	LINEDEV boardDev = 0;
        int  retr = 0;
	int  result = 0;
	int  boardH = 0;
        char brdname[64];
	int  index = 0;

	*boardNum = 0;
	
	result = strcmp(name,"DEV_CLASS_VOICE"); /* pstn channels - analog */
        if(result == 0){
		/* opens the boards until it fails to open */
		while(boardH != -1) {
		  index++;
		  sprintf(brdname, "dxxxB%d",index);
            	  boardH = dx_open(brdname, 0);
   		  if (boardH != -1)
		  {
			(*boardNum)++;
			dx_close(boardH);
		  }
		}
	}

	result = strcmp(name,"DEV_CLASS_DTI"); /* pstn channels - digital */
        if(result == 0){
		/* opens the boards until it fails to open */
		while(boardH != -1) {
		  index++;
		  sprintf(brdname, "dtiB%d",index);
                  boardH = dt_open(brdname, 0);
                  if (boardH != -1)
                  {
			(*boardNum)++;
			dt_close(boardH);
		  }
		}
	}

	result = strcmp(name,"IPM"); /* ip channels */
        if(result == 0){
		/* opens the boards until it fails to open */
		while(boardH != -1) {
		  index++;
		  sprintf(brdname, "ipmB%d",index);
                  boardH = ipm_Open(brdname, NULL, EV_SYNC);
                  if (boardH != -1)
                  {
			(*boardNum)++;
			ipm_Close(boardH, NULL);
		  }
		}
	}
/*
	if(strcmp(name,"IPM")== 0){
        result = sr_getboardcnt("IPM",boardNum);
		if(result == -1)
			return -1; 
	}
*/

	return 0;
}/* Function PDLsr_getboardcnt */

/*****FUNCTION***************************************************
*        NAME : PDLSetApplicationExitPath
* DESCRIPTION : set the signals for making appropriate exit from 
*               the application when these signals are recieved 
*       INPUT : pointer to function
*      OUTPUT : None
*     RETURNS : void 
*    CAUTIONS : None
****************************************************************/
void PDLSetApplicationExitPath(void (*pCloseWin)())
{
   signal(SIGINT,pCloseWin);   /* CTRL+C signal */
   signal(SIGTERM,pCloseWin);  /* Termination request */ 
   signal(SIGABRT,pCloseWin);  /* Abnormal termination */
   system("clear");
}


/*****FUNCTION***************************************************
*        NAME : PDLgetDateAndTime
* DESCRIPTION : Gets the current date and time
*       INPUT : pointer to string of date
*      OUTPUT : None
*     RETURNS : pointer to string of date
*    CAUTIONS : None
****************************************************************/
void  PDLgetDateAndTime(char *bufdate,char *buftime)
{
	struct timeval tmval;
	time_t ti;

	gettimeofday(&tmval,NULL);
	ti = tmval.tv_sec + (tmval.tv_usec / 1000000);
	sprintf(bufdate,"%s", ctime(&ti));
}

/*****FUNCTION***************************************************
*        NAME : PDLlower
* DESCRIPTION : converts the string to lower case
*       INPUT : pointer to string
*      OUTPUT : pointer to string in lower case
*     RETURNS : void
*    CAUTIONS : None
****************************************************************/
void PDLlower(char *p)
{
	int i = 0;
	while (p[i] != '\0')
	{
		p[i] = tolower(p[i]);
		i++;
	}
}

/*****FUNCTION***************************************************
*        NAME : PDLupper
* DESCRIPTION : converts the string to upper case
*       INPUT : pointer to string
*      OUTPUT : pointer to string in upper case
*     RETURNS : void
*    CAUTIONS : None
****************************************************************/
void PDLupper(char *p)
{
	int i = 0;
	while (p[i] != '\0')
	{
		p[i] = toupper(p[i]);
		i++;
	}
}


/*****FUNCTION***************************************************
*        NAME : PDLstrncmp
* DESCRIPTION : Compare characters of two strings without regard to case
*       INPUT : pointer to string1 ,pointer to string2, number of characters to compare 
*      OUTPUT : None
*     RETURNS : 0 - if equal
*    CAUTIONS : None
****************************************************************/
int PDLstrncmp(char *name1, char *name2, int count)
{ 
   int rc =0;

   rc = strncasecmp(name1, name2, count );

   return (rc);

}
/*****FUNCTION***************************************************
*        NAME : PDLsr_setparm
* DESCRIPTION : function allows the application to change 
*				the value of an SRL parameter
*       INPUT : None
*      OUTPUT : None
*     RETURNS : void
*    CAUTIONS : None
****************************************************************/
void PDLsr_setparm()
{
	int returnValue = 0;
	int mode = SR_POLLMODE;

	/* changes the value of an SRL parameter */
    returnValue = sr_setparm(SRL_DEVICE,    /* The value is always set to SRL_DEVICE when setting SRL parameters */
		                     SR_MODEID,     /* set event notification mode parameter to signal */
							 &mode);        /* For SR_MODEID, the value is expected to point to an integer 
	                                           that contains SR_SIGMODE or SR_POLLMODE */

	if (returnValue == -1 ) {
		printf("Unable to set to SRL Polled Mode\n");
		exit(0);
   }
}

/*****FUNCTION***************************************************
*        NAME : PDLwaitSRLEvtThread
* DESCRIPTION : Thread waiting for events the main 
*       INPUT : None
*      OUTPUT : None
*     RETURNS : void *
*    CAUTIONS : None
****************************************************************/
void *PDLwaitSRLEvtThread()
{
	while(1)
	{ 
		/* allows events to be handled using the Callback model */
		sr_waitevt(1000);
	}
}

/*****FUNCTION***************************************************
*        NAME : PDLcreateThread
* DESCRIPTION : Creates thread waiting for events
*       INPUT : None
*      OUTPUT : None
*     RETURNS : void 
*    CAUTIONS : None
****************************************************************/
void PDLcreateThread()
{

	pthread_t thread1;
	int returnValue = 0;

     returnValue = pthread_create(&thread1,              /* returned thraed ID */
		                          NULL,                  /* default attributes */
								  PDLwaitSRLEvtThread,   /* the thread function */  
								  (void *)NULL);        
	 if (returnValue != 0)
        {
            printf("create failed\n");
            exit(1);
        }
}

/*****FUNCTION***************************************************
*        NAME : PDLHandler 
* DESCRIPTION : calls to function callback_hdlr 
*       INPUT : pointer to parm
*      OUTPUT : None
*     RETURNS : long
*    CAUTIONS : None
****************************************************************/
long PDLHandler(void *parm)
{
	cbHandler();
	return (0);
}


/*****FUNCTION***************************************************
*        NAME : PDLsr_enbhdlr
* DESCRIPTION : enables the handler function callback_hdlr 
*       INPUT : pointer to function
*      OUTPUT : None
*     RETURNS : void
*    CAUTIONS : None
****************************************************************/
void PDLsr_enbhdlr(int (*callback_hdlr)())
{

	int returnValue = 0;

    PDLsr_setparm();
    PDLcreateThread();

	cbHandler = callback_hdlr;
	returnValue = sr_enbhdlr((long)EV_ANYDEV,            /* Dialogic device handle */
		                     (unsigned long)EV_ANYEVT,   /* Event type */
							  PDLHandler);               /* call back function */
	if (returnValue == -1){
		printf("%s","***** Error: unable to set-up the call back handler *****\n");
	    exit(0);
    }
    g_SRLDevice = _sr_regdev(SRL_DEVICE);
	
}

/*****FUNCTION***************************************************
*        NAME : PDLsr_dishdlr
* DESCRIPTION : disables the handler function callback_hdlr 
*       INPUT : pointer to function
*      OUTPUT : None
*     RETURNS : void
*    CAUTIONS : None
****************************************************************/
void PDLsr_dishdlr(int (*callback_hdlr)())
{

	int returnValue = 0;

	cbHandler = callback_hdlr;
	returnValue = sr_dishdlr((long)EV_ANYDEV,            /* Dialogic device handle */
		                     (unsigned long)EV_ANYEVT,   /* Event type */
							  PDLHandler);               /* call back function */
	if (returnValue == -1){
		printf("%s","***** Error: could not disable the call back handler *****\n");
	    exit(0);
    }
}
/*****FUNCTION***************************************************
*        NAME : PDLsr_getevtdev
* DESCRIPTION : Gets the event device from SRL queue
*       INPUT : None
*      OUTPUT : None
*     RETURNS : long
*    CAUTIONS : None
****************************************************************/
long PDLsr_getevtdev()
{
	return(sr_getevtdev());
}

/*****FUNCTION***************************************************
*        NAME : PDLsr_getevttype
* DESCRIPTION : Gets the event type from SRL queue
*       INPUT : None
*      OUTPUT : None
*     RETURNS : long
*    CAUTIONS : None
****************************************************************/
long PDLsr_getevttype()
{
	   return(sr_getevttype());
}

/*****FUNCTION***************************************************
*        NAME : PDLsr_putevt
* DESCRIPTION : post an event on SRL queue
*       INPUT : None
*      OUTPUT : None
*     RETURNS : long
*    CAUTIONS : None
****************************************************************/
long PDLsr_putevt(LINEDEV linedev, unsigned long evt, long len, void* datap, long err)
{
	long returnValue = 0;
	
    if ( linedev == SRL_DEVICE )
    {
        linedev = g_SRLDevice;
    }
	
	/* Post CTRL_CLOSE_EVENT to SRL queue, to end application */
	returnValue = _sr_putevt(linedev,              /* line device */
		                    evt,      /* received event */
							len,                      
							datap,
							err); 
	   if (returnValue < 0){
		   printf("Got error in _sr_putevt.\n");
		   exit(0);
	   }
	return returnValue;
}

/*****FUNCTION***************************************************
*        NAME : PDLFileOpen
* DESCRIPTION : opens a .vox file either for play or record
*       INPUT : file name to open, openning flags, permision mode
*      OUTPUT : None
*     RETURNS : int
*    CAUTIONS : None
****************************************************************/
int PDLFileOpen(char* FileName, int flags, int pmode)
{

	if(pmode == NOMODE){
		return(open(FileName, flags));
	}

	return(open(FileName, flags, pmode));
}

/*****FUNCTION***************************************************
*        NAME : PDLFileClose
* DESCRIPTION : closes a .vox file either for play or record
*       INPUT : handle - the file descriptor to close
*      OUTPUT : None
*     RETURNS : int
*    CAUTIONS : None
****************************************************************/
int PDLFileClose(int handle)
{

	return(close(handle));
}


/*****FUNCTION***************************************************
*	 NAME : PDLGetVersion
* DESCRIPTION : Gets the current version of this component
*       INPUT : void
*      OUTPUT : none
*     RETURNS : version string
*    CAUTIONS : None
****************************************************************/
char* PDLGetVersion(void)
{

        return(PDL_VERSION_STRING);
}
