/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* DIALOGIC CONFIDENTIAL
*
* Copyright (C) 2007 Dialogic Corporation. All Rights Reserved.
* The source code contained or described herein and all documents related
* to the source code ("Material") are owned by Dialogic Corporation or its
* suppliers or licensors. Title to the Material remains with Dialogic Corporation
* or its suppliers and licensors. The Material contains trade secrets and
* proprietary and confidential information of Dialogic or its suppliers and
* licensors. The Material is protected by worldwide copyright and trade secret
* laws and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted, distributed,
* or disclosed in any way without Dialogic's prior express written permission.
*
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/


#include "NetworkConnectionMgr.h"


NetworkConnectionMgr::NetworkConnectionMgr()
{
	Print(LOG_DEBUG,"+ NetworkConnectionMgr::NetworkConnectionMgr");
	m_NumNetworkConnections = 0;
	int i = 0;
	for (i=0; i<MAX_NETWORK_CONNECTIONS; i++)
	{
		m_pNetworkConnections[i] = NULL;
	}
	m_pBoardDevice = NULL;
	Print(LOG_DEBUG,"- NetworkConnectionMgr::NetworkConnectionMgr");
}

NetworkConnectionMgr::~NetworkConnectionMgr()
{
	Print(LOG_DEBUG,"+ NetworkConnectionMgr::~NetworkConnectionMgr");
	if (m_pBoardDevice != NULL)
	{
		delete m_pBoardDevice;
		m_pBoardDevice = NULL;
	}
	Print(LOG_DEBUG,"- NetworkConnectionMgr::~NetworkConnectionMgr");
}

int NetworkConnectionMgr::Initialize(char* a_BoardDevName)
{
	Print(LOG_DEBUG,"+ NetworkConnectionMgr::Initialize");
	int rc = 0;

	m_pBoardDevice = new BoardDevice;
	m_pBoardDevice->Open(a_BoardDevName);
	Print(LOG_DEBUG,"- NetworkConnectionMgr::Initialize");
	return rc;
}

NetworkConnection* NetworkConnectionMgr::Allocate(const char* a_SipDeviceName, const char* a_MediaDeviceName)
{
	Print(LOG_DEBUG,"+ NetworkConnectionMgr::Allocate");
	Print(LOG_INFO,"\tAllocating new Network Connection");
	Print(LOG_INFO,"\tSip Device name = %s. Media Device name = %s\n",a_SipDeviceName,a_MediaDeviceName);
	NetworkConnection* pNetworkConnection = new NetworkConnection;
	m_pNetworkConnections[m_NumNetworkConnections] = pNetworkConnection;
	m_NumNetworkConnections++;
	if (pNetworkConnection->Open(a_SipDeviceName,a_MediaDeviceName) != 0)
	{
		Deallocate(pNetworkConnection);
		pNetworkConnection=NULL;
	}
	Print(LOG_DEBUG,"- NetworkConnectionMgr::Allocate");
	return pNetworkConnection;
}

int NetworkConnectionMgr::Deallocate(NetworkConnection* a_pNetworkConnection)
{
	Print(LOG_DEBUG,"+ NetworkConnectionMgr::DeAllocate");
	int rc = -1;
	Print(LOG_INFO,"\tDeallocating existing Network Connection");
	int i=0;
	int j=0;
	if (a_pNetworkConnection)
	{
		for (i=0;i<m_NumNetworkConnections;i++)
		{
			if (a_pNetworkConnection == m_pNetworkConnections[i])
			{
				m_pNetworkConnections[i]->Close();
				delete m_pNetworkConnections[i];
				rc = 0;
				for (j=i;j<m_NumNetworkConnections-1;j++)
				{
					m_pNetworkConnections[j] = m_pNetworkConnections[j+1];
				}
				m_NumNetworkConnections--;
				m_pNetworkConnections[m_NumNetworkConnections] = NULL;
				break;
			}
		}
	}
	Print(LOG_DEBUG,"- NetworkConnectionMgr::DeAllocate");
	return rc;
}

Device* NetworkConnectionMgr::FindDeviceByHandle(long a_DeviceHandle, char* a_DeviceName)
{
	Print(LOG_DEBUG,"+ NetworkConnectionMgr::FindDeviceByHandle");
	Device* pDevice = NULL;
	int i;
	if (m_pBoardDevice->GetDeviceHandle() == a_DeviceHandle)
	{
		pDevice = m_pBoardDevice;
		strcpy(a_DeviceName,m_pBoardDevice->GetDeviceName());
	}
	else
	{
		for (i=0;i<m_NumNetworkConnections;i++)
		{
			if (m_pNetworkConnections[i]->GetSipDevice()->GetDeviceHandle() == a_DeviceHandle)
			{
				pDevice = m_pNetworkConnections[i]->GetSipDevice();
				strcpy(a_DeviceName,m_pNetworkConnections[i]->GetSipDevice()->GetDeviceName());
				break;
			}
			if (m_pNetworkConnections[i]->GetMediaDevice()->GetDeviceHandle() == a_DeviceHandle)
			{
				pDevice = m_pNetworkConnections[i]->GetMediaDevice();
				strcpy(a_DeviceName,m_pNetworkConnections[i]->GetMediaDevice()->GetDeviceName());
				break;
			}
		}
	}
	Print(LOG_DEBUG,"- NetworkConnectionMgr::FindDeviceByHandle");
	return pDevice;
}

NetworkConnection* NetworkConnectionMgr::FindNetworkConnectionByHandle(long a_DeviceHandle, char* a_DeviceName)
{
	Print(LOG_DEBUG,"+ NetworkConnectionMgr::FindNetworkConnectionByHandle");
	NetworkConnection* pNetworkConnection = NULL;
	int i;
	long hSipDevice,hMediaDevice;
	for (i=0;i<m_NumNetworkConnections;i++)
	{
		hSipDevice = m_pNetworkConnections[i]->GetSipDevice()->GetDeviceHandle();
		hMediaDevice = m_pNetworkConnections[i]->GetMediaDevice()->GetDeviceHandle();

		if (hSipDevice == a_DeviceHandle)
		{
			pNetworkConnection = m_pNetworkConnections[i];
			strcpy(a_DeviceName,m_pNetworkConnections[i]->GetSipDevice()->GetDeviceName());
			break;
		}
		if (hMediaDevice == a_DeviceHandle)
		{
			pNetworkConnection = m_pNetworkConnections[i];
			strcpy(a_DeviceName,m_pNetworkConnections[i]->GetMediaDevice()->GetDeviceName());
			break;
		}
	}
	Print(LOG_DEBUG,"- NetworkConnectionMgr::FindNetworkConnectionByHandle");
	return pNetworkConnection;
}
