/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* DIALOGIC CONFIDENTIAL
*
* Copyright (C) 2007 Dialogic Corporation. All Rights Reserved.
* The source code contained or described herein and all documents related
* to the source code ("Material") are owned by Dialogic Corporation or its
* suppliers or licensors. Title to the Material remains with Dialogic Corporation
* or its suppliers and licensors. The Material contains trade secrets and
* proprietary and confidential information of Dialogic or its suppliers and
* licensors. The Material is protected by worldwide copyright and trade secret
* laws and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted, distributed,
* or disclosed in any way without Dialogic's prior express written permission.
*
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
//
// sdpContainers.cpp : 
//

#include "sdpAPI.h"


///////////////////////////////////////////////////////////////////////////////////
// class sdpTimeDescription : public sdpElement
///////////////////////////////////////////////////////////////////////////////////
sdpTimeDescription::sdpTimeDescription()
{
}

void sdpTimeDescription::clear()
{
	m_Time.clear();
	m_RepeatTimes.clear();
}

sdpRepeatTimes* sdpTimeDescription::repeatTimes()
{
	return &m_RepeatTimes;
}

sdpTime* sdpTimeDescription::time()
{
	return &m_Time;
}
///////////////////////////////////////////////////////////////////////////////////




///////////////////////////////////////////////////////////////////////////////////
// class sdpMediaDescription : public sdpElement
///////////////////////////////////////////////////////////////////////////////////
sdpMediaDescription::sdpMediaDescription()
{
}

sdpMediaDescription::~sdpMediaDescription()
{
	clear();
}

void sdpMediaDescription::clear()
{
	m_Bandwidth.clear();
	m_Connection.clear();
	m_EncryptionKey.clear();
	m_Media.clear();
	m_MediaTitle.clear();
}

sdpAttributeList* sdpMediaDescription::attributeList()
{
	return &m_AttributeList;
}

sdpBandwidth* sdpMediaDescription::bandwidth()
{
	return &m_Bandwidth;
}

sdpConnection* sdpMediaDescription::connection()
{
	return &m_Connection;
}

sdpEncryptionKey* sdpMediaDescription::encryptionKey()
{
	return &m_EncryptionKey;
}

sdpMedia* sdpMediaDescription::media()
{
	return &m_Media;
}

sdpMediaTitle* sdpMediaDescription::mediaTitle()
{
	return &m_MediaTitle;
}
///////////////////////////////////////////////////////////////////////////////////




///////////////////////////////////////////////////////////////////////////////////
// class sdpSessionDescription : public sdpElement
///////////////////////////////////////////////////////////////////////////////////
sdpSessionDescription::sdpSessionDescription()
{
}

sdpSessionDescription::~sdpSessionDescription()
{
	clear();
}

void sdpSessionDescription::clear()
{
	m_Bandwidth.clear();
	m_Connection.clear();
	m_EncryptionKey.clear();
	m_Origin.clear();
	m_SessionInformation.clear();
	m_SessionName.clear();
	m_TimezoneAdjustment.clear();
	m_URI.clear();
	m_Version.clear();
	m_AttributeList.clear();
	m_EmailAddressList.clear();
	m_MediaDescriptionList.clear();
	m_PhoneNumberList.clear();
	m_TimeDescriptionList.clear();
}

sdpAttributeList* sdpSessionDescription::attributeList()
{
	return &m_AttributeList;
}

sdpBandwidth* sdpSessionDescription::bandwidth()
{
	return &m_Bandwidth;
}

sdpConnection* sdpSessionDescription::connection()
{
	return &m_Connection;
}

sdpEmailAddressList* sdpSessionDescription::emailAddressList()
{
	return &m_EmailAddressList;
}

sdpEncryptionKey* sdpSessionDescription::encryptionKey()
{
	return &m_EncryptionKey;
}

sdpMediaDescriptionList* sdpSessionDescription::mediaDescriptionList()
{
	return &m_MediaDescriptionList;
}

sdpOrigin* sdpSessionDescription::origin()
{
	return &m_Origin;
}

sdpPhoneNumberList* sdpSessionDescription::phoneNumberList()
{
	return &m_PhoneNumberList;
}

sdpSessionInformation* sdpSessionDescription::sessionInformation()
{
	return &m_SessionInformation;
}

sdpSessionName* sdpSessionDescription::sessionName()
{
	return &m_SessionName;
}

sdpTimeDescriptionList* sdpSessionDescription::timeDescriptionList()
{
	return &m_TimeDescriptionList;
}

sdpTimezoneAdjustment* sdpSessionDescription::timezoneAdjustment()
{
	return &m_TimezoneAdjustment;
}

sdpURI* sdpSessionDescription::uri()
{
	return &m_URI;
}

sdpVersion* sdpSessionDescription::version()
{
	return &m_Version;
}

void sdpSessionDescription::importSDP(const char* a_SDPString, bool a_Debug)
{
	char Id;
	char Equal;
	char Value[512];
	sdpMediaDescription* pMediaDescription = NULL;
	sdpTimeDescription* pTimeDescription = NULL;
	char* pAllocatedData = NULL;
	char* pData = NULL;
	int gotCryptoAttribute = 0;

	if (a_SDPString != NULL)
	{
		pAllocatedData = new char[strlen(a_SDPString)+1];
		strcpy(pAllocatedData,a_SDPString);
		pData = pAllocatedData;
	}
	
	if (a_Debug)
	{
		printf ("\n\n");
		printf ("******************************************************************\n");
		printf ("********************** Loading contents of SDP *******************\n");
		printf ("******************************************************************\n");
	}

	if (!pData)
	{
		if (a_Debug)
		{
			printf ("\n\n");
			printf ("********************** Input string is invalid *******************\n");
			printf ("\n\n");
		}
		return;
	}

	while (pData != NULL)
	{
		Id = '?';
		char* pCurrentLine = pData;
		pData = strchr(pCurrentLine,'\n');
		if (pData)
		{
			pData[0]='\0';
			pData = pData + sizeof(char);
		}

		int len = strlen(pCurrentLine) - 2;
		if (strlen(pCurrentLine) == 0)
		{
			continue;
		}
		sscanf(pCurrentLine,"%c%c",&Id,&Equal);
		strcpy(Value,pCurrentLine);


		switch (Id)
		{
			case 'v':
				if (a_Debug) printf ("... Loading Version = %s\n", Value);
				version()->setString(Value);
				break;
			case 'o':
				if (a_Debug) printf ("... Loading Origin = %s\n", Value);
				origin()->setString(Value);
				break;
			case 's':
				if (a_Debug) printf ("... Loading Session Name = %s\n", Value);
				sessionName()->setString(Value);
				break;
			case 'i':
				if (pMediaDescription == NULL)
				{
					if (a_Debug) printf ("... Loading Session Info = %s\n", Value);
					sessionInformation()->setString(Value);
				}
				else
				{
					if (a_Debug) printf ("... Loading Media Title = %s\n", Value);
					pMediaDescription->mediaTitle()->setString(Value);
				}
				break;
			case 'u':
				if (a_Debug) printf ("... Loading URI = %s\n", Value);
				uri()->setString(Value);
				break;
			case 'e':
				{
					if (a_Debug) printf ("... Loading Email Address = %s\n", Value);
					sdpEmailAddress* pEmailAddress = emailAddressList()->addItem();
					pEmailAddress->setString(Value);
				}
				break;
			case 'p':
				{
					sdpPhoneNumberList* pPhoneNumberList = phoneNumberList();
					if (a_Debug) printf ("... Loading Phone Number #%d= %s\n", pPhoneNumberList->numItem()+1,Value);
					sdpPhoneNumber* pPhoneNumber = pPhoneNumberList->addItem();
					pPhoneNumber->setString(Value);
				}
				break;
			case 'c':
				if (pMediaDescription == NULL)
				{
					if (a_Debug) printf ("... Loading Session Description Connection = %s\n", Value);
					connection()->setString(Value);
				}
				else
				{
					if (a_Debug) printf ("... Loading Media Description Connection = %s\n", Value);
					pMediaDescription->connection()->setString(Value);
				}
				break;
			case 'b':
				if (pMediaDescription == NULL)
				{
					if (a_Debug) printf ("... Loading Session Description Bandwidth = %s\n", Value);
					bandwidth()->setString(Value);
				}
				else
				{
					if (a_Debug) printf ("... Loading Media Description Bandwidth = %s\n", Value);
					pMediaDescription->bandwidth()->setString(Value);
				}
				break;
			case 't':
				{
					sdpTimeDescriptionList* pTimeDescriptionList = timeDescriptionList();
					if (a_Debug) printf ("... Loading Time #%d = %s\n", pTimeDescriptionList->numItem()+1,Value);
					pTimeDescription = pTimeDescriptionList->addItem();
					pTimeDescription->time()->setString(Value);
				}
				break;
			case 'r':
				if (pTimeDescription)
				{
					if (a_Debug) printf ("... Loading Repeat Time = %s\n", Value);
					pTimeDescription->repeatTimes()->setString(Value);
				}
				break;
			case 'z':
				if (a_Debug) printf ("Timezone Adjustment = %s\n", Value);
				timezoneAdjustment()->setString(Value);
				break;
			case 'k':
				if (pMediaDescription == NULL)
				{
					if (a_Debug) printf ("... Loading Session Description Encryption Key = %s\n", Value);
					encryptionKey()->setString(Value);
				}
				else
				{
					if (a_Debug) printf ("... Loading Media Description Encryption Key = %s\n", Value);
					pMediaDescription->encryptionKey()->setString(Value);
				}
				break;
			case 'a':
				gotCryptoAttribute = 0;
				if(len >= 6 && strncmp(pCurrentLine+2,"crypto", 6) == 0)
				{
					gotCryptoAttribute = 1;
				}
				if (pMediaDescription == NULL)
				{
					sdpAttributeList* pAttributeList = attributeList();
					if (a_Debug) printf ("... Loading Session Description Attribute #%d = %s\n", pAttributeList->numItem()+1,Value);
					sdpAttribute* pAttribute;
					if(gotCryptoAttribute == 1)
					{
						pAttribute = new sdpCryptoAttribute();
						pAttributeList->addItem(pAttribute);
					}
					else
					{	
						pAttribute = pAttributeList->addItem();
					}
					pAttribute->setString(Value);
				}
				else
				{
					sdpAttributeList* pAttributeList = pMediaDescription->attributeList();
					if (a_Debug) printf ("... Loading Media Description Attribute #%d = %s\n", pAttributeList->numItem()+1,Value);
					sdpAttribute* pAttribute;
					if(gotCryptoAttribute == 1)
					{
						pAttribute = new sdpCryptoAttribute();
						pAttributeList->addItem(pAttribute);
					}
					else
					{	
						pAttribute = pAttributeList->addItem();
					}
					pAttribute->setString(Value);
				}
				break;
			case 'm':
				{
					sdpMediaDescriptionList* pMediaDescriptionList = mediaDescriptionList();
					if (a_Debug) printf ("... Loading Media Name and transport address #%d = %s\n", pMediaDescriptionList->numItem()+1,Value);
					pMediaDescription = pMediaDescriptionList->addItem();
					pMediaDescription->media()->setString(Value);
				}
				break;
			default:
				if (a_Debug) printf ("UNKNOWN FIELD found - Id = %c\n", Id);
				break;
		}
	}

	if (a_Debug) 
	{
		printf ("******************************************************************\n");
		printf ("\n\n");
	}

	delete []pAllocatedData;
}

int sdpSessionDescription::exportSDP(char* a_OutputSDP,int a_MaxLen,bool a_Debug)
{
	if (!a_OutputSDP)
	{
		return -1;
	}

	int i,j;
	strcpy(a_OutputSDP,"");

	if (a_Debug)
	{
		printf ("\n\n");
		printf ("******************************************************************\n");
		printf ("************************** Generating SDP ************************\n");
		printf ("******************************************************************\n");
		printf ("Number of Session Description Attributes = %d\n", attributeList()->numItem());
		printf ("Number of Email Addresses = %d\n", emailAddressList()->numItem());
		printf ("Number of Phone Numbers = %d\n", phoneNumberList()->numItem());
		printf ("Number of Time Descriptions = %d\n", timeDescriptionList()->numItem());
		printf ("Number of Media Descriptions = %d\n", mediaDescriptionList()->numItem());
		for (i=0;i<mediaDescriptionList()->numItem();i++)
		{
			printf ("Media Description #%d - Number of Attributes = %d\n", i+1,mediaDescriptionList()->getItem(i)->attributeList()->numItem());
		}
		printf ("\n");
	}

	if ( (storeSDP (a_OutputSDP, version()->getString(), a_MaxLen, a_Debug) < 0) ) return -1;
	if ( (storeSDP (a_OutputSDP, origin()->getString(), a_MaxLen, a_Debug) < 0) ) return -1;
	if ( (storeSDP (a_OutputSDP, sessionName()->getString(), a_MaxLen, a_Debug) < 0) ) return -1;
	if ( (storeSDP (a_OutputSDP, sessionInformation()->getString(), a_MaxLen, a_Debug) < 0) ) return -1;
	if ( (storeSDP (a_OutputSDP, uri()->getString(), a_MaxLen, a_Debug) < 0) ) return -1;
	
	for (i=0;i<emailAddressList()->numItem();i++)
	{
		if ( (storeSDP (a_OutputSDP, emailAddressList()->getItem(i)->getString(), a_MaxLen, a_Debug) < 0) ) return -1;
	}
	for (i=0;i<phoneNumberList()->numItem();i++)
	{
		if ( (storeSDP (a_OutputSDP, phoneNumberList()->getItem(i)->getString(), a_MaxLen, a_Debug) < 0) ) return -1;
	}

	if ( (storeSDP (a_OutputSDP, connection()->getString(), a_MaxLen, a_Debug) < 0) ) return -1;
	if ( (storeSDP (a_OutputSDP, bandwidth()->getString(), a_MaxLen, a_Debug) < 0) ) return -1;

	for (i=0;i<timeDescriptionList()->numItem();i++)
	{
		if ( (storeSDP (a_OutputSDP, timeDescriptionList()->getItem(i)->time()->getString(), a_MaxLen, a_Debug) < 0) ) return -1;
		if ( (storeSDP (a_OutputSDP, timeDescriptionList()->getItem(i)->repeatTimes()->getString(), a_MaxLen, a_Debug) < 0) ) return -1;
	}

	if ( (storeSDP (a_OutputSDP, timezoneAdjustment()->getString(), a_MaxLen, a_Debug) < 0) ) return -1;
	if ( (storeSDP (a_OutputSDP, encryptionKey()->getString(), a_MaxLen, a_Debug) < 0) ) return -1;

	for (i=0;i<attributeList()->numItem();i++)
	{
		if ( (storeSDP (a_OutputSDP, attributeList()->getItem(i)->getString(), a_MaxLen, a_Debug) < 0) ) return -1;
	}

	for (i=0;i<mediaDescriptionList()->numItem();i++)
	{
		sdpMediaDescription* pMediaDescription = mediaDescriptionList()->getItem(i);
		if ( (storeSDP (a_OutputSDP, pMediaDescription->media()->getString(), a_MaxLen, a_Debug) < 0) ) return -1;
		if ( (storeSDP (a_OutputSDP, pMediaDescription->mediaTitle()->getString(), a_MaxLen, a_Debug) < 0) ) return -1;
		if ( (storeSDP (a_OutputSDP, pMediaDescription->connection()->getString(), a_MaxLen, a_Debug) < 0) ) return -1;
		if ( (storeSDP (a_OutputSDP, pMediaDescription->bandwidth()->getString(), a_MaxLen, a_Debug) < 0) ) return -1;
		if ( (storeSDP (a_OutputSDP, pMediaDescription->encryptionKey()->getString(), a_MaxLen, a_Debug) < 0) ) return -1;
		for (j=0;j<pMediaDescription->attributeList()->numItem();j++)
		{
			if ( (storeSDP (a_OutputSDP, pMediaDescription->attributeList()->getItem(j)->getString(), a_MaxLen, a_Debug) < 0) ) return -1;
		}
	}
	if (a_Debug)
	{
		printf ("******************************************************************\n");
		printf ("\n\n");
	}
	return 0;
}

int sdpSessionDescription::storeSDP(char* a_SDP,const char* a_Element,unsigned int a_MaxLen,bool a_Debug)
{
	bool printOnly = false;
	if (!a_SDP)
	{
		return 0;
	}
	if ( !a_SDP )
	{
		printOnly = true;
	}
	if ( (!a_Element) || (strlen(a_Element)<=0) )
	{
		return 0;
	}

	if (a_Debug)
	{
		printf ("%s\n", a_Element);
	}
	if (!printOnly)
	{
		if ((strlen(a_SDP) + strlen(a_Element)) > (unsigned int)a_MaxLen)
		{
			if (a_Debug)
			{
				printf ("Element \"%s\" was not written to SDP.  MaxLen exceeded\n",a_Element);
			}
			return -1;
		}
		else
		{
			sprintf (a_SDP,"%s%s\n",a_SDP,a_Element);
		}
	}
	return strlen(a_Element);
}
///////////////////////////////////////////////////////////////////////////////////


