/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* DIALOGIC CONFIDENTIAL
*
* Copyright (C) 2007 Dialogic Corporation. All Rights Reserved.
* The source code contained or described herein and all documents related
* to the source code ("Material") are owned by Dialogic Corporation or its
* suppliers or licensors. Title to the Material remains with Dialogic Corporation
* or its suppliers and licensors. The Material contains trade secrets and
* proprietary and confidential information of Dialogic or its suppliers and
* licensors. The Material is protected by worldwide copyright and trade secret
* laws and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted, distributed,
* or disclosed in any way without Dialogic's prior express written permission.
*
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/

#ifndef SDP_CONTAINERS_DEFINE
#define SDP_CONTAINERS_DEFINE


///////////////////////////////////////////////////////////////////////////////////
//!  sdpTimeDescription class. 
/*!  Contains an sdpTime and sdpRepeatTimes object and is contained in an sdpSessionDescription object.*/
class sdpTimeDescription
{
public:
	sdpTimeDescription();
public:
	//!  Clears sdpTimeDescription. 
	/*!  This method clears the contents of the sdpTimeDescription object including the sdpTime and sdpRepeatTimes objects.
	\return	void */
	void			clear();
	//!  Returns the sdpRepeatTimes object. 
	/*!  This method returns the sdpRepeatTimes object contained in the sdpTimeDescription object
	\return	sdpRepeatTimes* - pointer to the sdpRepeatTimes object*/
	sdpRepeatTimes* repeatTimes();
	//!  Returns the sdpTime object. 
	/*!  This method returns the sdpTime object contained in the sdpTimeDescription object
	\return	sdpTime			- pointer to the sdpTime object */
	sdpTime*		time();
private:
	sdpRepeatTimes	m_RepeatTimes;
	sdpTime			m_Time;
};
///////////////////////////////////////////////////////////////////////////////////




///////////////////////////////////////////////////////////////////////////////////
//!  sdpMediaDescription class. 
/*!  Contains sdpMedia, sdpMediaTitle, sdpConnection, sdpBandwidth, sdpEncryptionKey, and sdpAttribute objects..*/
class sdpMediaDescription
{
public:
	sdpMediaDescription();
	~sdpMediaDescription();
public:
	//!  Returns the sdpAttributeList object. 
	/*!  This method returns the sdpAttributeList object contained in the sdpMediaDescription object
	\return	sdpAttributeList* - pointer to the sdpAttributeList contained in sdpMediaDescription */
	sdpAttributeList*	attributeList();
	//!  Returns the sdpBandwidth object. 
	/*!  This method returns the sdpBandwidth object contained in the sdpMediaDescription object
	\return	sdpBandwidth* - pointer to the sdpBandwidth contained in the sdpMediaDescription */
	sdpBandwidth*		bandwidth();
	//!  Clears the Media Description. 
	/*!  This method clears the Media Description including all of it contents.
	\return	void */
	void				clear();
	//!  Returns the sdpConnection object. 
	/*!  This method returns the sdpConnection object contained in the sdpMediaDescription object
	\return	sdpConnection* - pointer to the sdpConnection contained in the sdpMediaDescription */
	sdpConnection*		connection();
	//!  Returns the sdpEncryptionKey object. 
	/*!  This method returns the sdpEncryptionKey object contained in the sdpMediaDescription object
	\return	sdpEncryptionKey* - pointer to the sdpEncryptionKey contained in the sdpMediaDescription */
	sdpEncryptionKey*	encryptionKey();
	//!  Returns the sdpMedia object. 
	/*!  This method returns the sdpMedia object contained in the sdpMediaDescription object
	\return	sdpMedia* - pointer to the sdpMedia contained in the sdpMediaDescription */
	sdpMedia*			media();
	//!  Returns the sdpMediaTitle object. 
	/*!  This method returns the sdpMediaTitle object contained in the sdpMediaDescription object
	\return	sdpMediaTitle* - pointer to the sdpMediaTitle contained in the sdpMediaDescription */
	sdpMediaTitle*		mediaTitle();
private:
	sdpBandwidth		m_Bandwidth;
	sdpConnection		m_Connection;
	sdpEncryptionKey	m_EncryptionKey;
	sdpMedia			m_Media;
	sdpMediaTitle		m_MediaTitle;
	sdpAttributeList	m_AttributeList;
friend class sdpSessionDescription;
};
///////////////////////////////////////////////////////////////////////////////////




///////////////////////////////////////////////////////////////////////////////////
//!  sdpSessionDescription class. 
/*!  Contains 	sdpAttribute, sdpBandwidth, sdpConnection, sdpEmailAddress, sdpEncryptionKey, sdpMediaDescription, sdpOrigin, sdpPhoneNumber, sdpSessionInformation, sdpSessionName, sdpTimeDescription, sdpTimezoneAdjustment, sdpURI, and sdpVersion objects.*/
class sdpSessionDescription
{
public:  // constructors
	//!  sdpSessionDescription constructor. 
	/*!  Creates a blank sdpSessionDescription object*/
	sdpSessionDescription();
	~sdpSessionDescription();
public:  // public interface
	//!  Returns the sdpAttributeList object. 
	/*!  This method returns the sdpAttributeList object contained in the sdpSessionDescription object
	\return	sdpAttributeList* - pointer to the sdpAttributeList contained in sdpSessionDescription */
	sdpAttributeList*		attributeList();
	//!  Returns the sdpBandwidth object. 
	/*!  This method returns the sdpBandwidth object contained in the sdpSessionDescription object
	\return	sdpBandwidth* - pointer to the sdpBandwidth contained in the sdpSessionDescription*/
	sdpBandwidth*			bandwidth();
	//!  Clears value. 
	/*!  This method clears the sdpSessionDescription object and all of the objects it contains.*/
	void					clear();
	//!  Returns the sdpConnection object. 
	/*!  This method returns the sdpConnection object contained in the sdpSessionDescription object
	\return	sdpConnection* - pointer to the sdpConnection contained in the sdpSessionDescription*/
	sdpConnection*			connection();
	//!  Returns the sdpEmailAddressList object. 
	/*!  This method returns the sdpEmailAddressList object contained in the sdpSessionDescription object
	\return	sdpEmailAddressList* - pointer to the sdpEmailAddressList contained in sdpSessionDescription */
	sdpEmailAddressList*	emailAddressList();
	//!  Returns the sdpEncryptionKey object. 
	/*!  This method returns the sdpEncryptionKey object contained in the sdpSessionDescription object
	\return	sdpEncryptionKey* - pointer to the sdpEncryptionKey contained in the sdpSessionDescription*/
	sdpEncryptionKey*		encryptionKey();
	//!  Exports a fully qualified SDP to a string. 
	/*!  This method exports a fully qualified SDP string based on the values of the contained objects.
		\param a_SDP	- a preallocated buffer to store the generated SDP
		\param a_MaxLen	- size of allocated buffer
		\param a_Debug	- true for debug mode which will generate stdout debug information
		\return returns 0 for success, -1 for failure if input buffer size is not large enough.*/
	int						exportSDP(char* a_SDP,int a_MaxLen,bool a_Debug=false);
	//!  Imports a fully qualified SDP from a string. 
	/*!  This method imports a fully qualified SDP from a string initializes the contains of the objects appropriately.
		\param a_SDP	- a buffer containing the fully qualified SDP
		\param a_Debug	- true for debug mode which will generate stdout debug information
		\return returns 0 for success, -1 for failure if input buffer size is not large enough.*/
	void					importSDP(const char* a_SDP,bool a_Debug);
	//!  Returns the sdpMediaDescriptionList object. 
	/*!  This method returns the sdpMediaDescriptionList object contained in the sdpSessionDescription object
	\return	sdpAttributeList* - pointer to the sdpMediaDescriptionList contained in sdpSessionDescription */
	sdpMediaDescriptionList*	mediaDescriptionList();
	//!  Returns the sdpOrigin object. 
	/*!  This method returns the sdpOrigin object contained in the sdpSessionDescription object
	\return	int - number of sdpOrigins contained in the sdpSessionDescription*/
	sdpOrigin*				origin();
	//!  Returns the sdpPhoneNumberList object. 
	/*!  This method returns the sdpPhoneNumberList object contained in the sdpSessionDescription object
	\return	sdpAttributeList* - pointer to the sdpPhoneNumberList contained in sdpSessionDescription */
	sdpPhoneNumberList*		phoneNumberList();
	//!  Returns the sdpSessionInformation object. 
	/*!  This method returns the sdpSessionInformation object contained in the sdpSessionDescription object
	\return	sdpSessionInformation* - pointer to the sdpSessionInformation contained in the sdpSessionDescription*/
	sdpSessionInformation*	sessionInformation();
	//!  Returns the sdpSessionName object. 
	/*!  This method returns the sdpName object contained in the sdpSessionDescription object
	\return	sdpSessionName* - pointer to the sdpSessionName contained in the sdpSessionDescription*/
	sdpSessionName*			sessionName();
	//!  Returns the sdpTimeDescriptionList object. 
	/*!  This method returns the sdpTimeDescriptionList object contained in the sdpSessionDescription object
	\return	sdpAttributeList* - pointer to the sdpTimeDescriptionList contained in sdpSessionDescription */
	sdpTimeDescriptionList*		timeDescriptionList();
	//!  Returns the sdpTimezoneAdjustment object. 
	/*!  This method returns the sdpTimezoneAdjustment object contained in the sdpSessionDescription object
	\return	sdpTimezoneAdjustment* - pointer to the sdpTimezoneAdjustment contained in the sdpSessionDescription*/
	sdpTimezoneAdjustment*	timezoneAdjustment();
	//!  Returns the sdpURI object. 
	/*!  This method returns the sdpURI object contained in the sdpSessionDescription object
	\return	sdpURI* - pointer to the sdpURI contained in the sdpSessionDescription*/
	sdpURI*					uri();
	//!  Returns the sdpVersion object. 
	/*!  This method returns the sdpVersion object contained in the sdpSessionDescription object
	\return	sdpVersion* - pointer to the sdpVersion contained in the sdpSessionDescription*/
	sdpVersion*				version();
private: // private utilities
	int						storeSDP(char*,const char*,unsigned int,bool);
private: // member variables
	sdpBandwidth			m_Bandwidth;
	sdpConnection			m_Connection;
	sdpEncryptionKey		m_EncryptionKey;
	sdpOrigin				m_Origin;
	sdpSessionInformation	m_SessionInformation;
	sdpSessionName			m_SessionName;
	sdpTimezoneAdjustment	m_TimezoneAdjustment;
	sdpURI					m_URI;
	sdpVersion				m_Version;
	sdpAttributeList		m_AttributeList;
	sdpEmailAddressList		m_EmailAddressList;
	sdpMediaDescriptionList	m_MediaDescriptionList;
	sdpPhoneNumberList		m_PhoneNumberList;
	sdpTimeDescriptionList	m_TimeDescriptionList;
};
///////////////////////////////////////////////////////////////////////////////////



#endif
