/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* DIALOGIC CONFIDENTIAL
*
* Copyright (C) 2007 Dialogic Corporation. All Rights Reserved.
* The source code contained or described herein and all documents related
* to the source code ("Material") are owned by Dialogic Corporation or its
* suppliers or licensors. Title to the Material remains with Dialogic Corporation
* or its suppliers and licensors. The Material contains trade secrets and
* proprietary and confidential information of Dialogic or its suppliers and
* licensors. The Material is protected by worldwide copyright and trade secret
* laws and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted, distributed,
* or disclosed in any way without Dialogic's prior express written permission.
*
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
//
// sdpLists.cpp : 
//

#include "sdpAPI.h"





///////////////////////////////////////////////////////////////////////////////////
// class sdpElementList
///////////////////////////////////////////////////////////////////////////////////
sdpElementList::sdpElementList()
{
	m_pElements = NULL;
	m_NumItem = 0;
}

sdpElementList::~sdpElementList()
{
	delete m_pElements;
	m_NumItem = 0;
	m_pElements = NULL;
}

void sdpElementList::addItem(void* a_pElement)
{
	if (a_pElement)
	{
		if (m_pElements == NULL)
		{
			m_pElements = (void**)malloc(sizeof(void*));
		}
		else
		{
			m_pElements = (void**)realloc( m_pElements,sizeof(void*) * (m_NumItem+1) );
		}
		m_pElements[m_NumItem] = a_pElement;
		m_NumItem++;
	}
}

void sdpElementList::deleteItem(void* a_Element)
{
	int i=0;
	int j=0;
	if (a_Element)
	{
		for (i=0;i<m_NumItem;i++)
		{
			if (a_Element == m_pElements[i])
			{
				for (j=i;j<m_NumItem-1;j++)
				{
					m_pElements[j] = m_pElements[j+1];
				}
				m_NumItem--;
				break;
			}
		}
	}
}

void* sdpElementList::getItem(int a_Index)
{
	void* pElement = NULL;
	if (a_Index < m_NumItem)
	{
		pElement = m_pElements[a_Index];
	}
	return pElement;
}

int sdpElementList::numItem()
{
	return m_NumItem;
}
///////////////////////////////////////////////////////////////////////////////////




///////////////////////////////////////////////////////////////////////////////////
//  class sdpAttributeList : public sdpElementList
///////////////////////////////////////////////////////////////////////////////////
sdpAttributeList::sdpAttributeList()
{
}

sdpAttributeList::~sdpAttributeList()
{
	clear();
}

sdpAttribute* sdpAttributeList::addItem()
{
	sdpAttribute* pAttribute = new sdpAttribute;
	sdpElementList::addItem(pAttribute);
	return pAttribute;
}

void sdpAttributeList::addItem(sdpAttribute* a_Attribute)
{
	sdpElementList::addItem(a_Attribute);
	return;
}

void sdpAttributeList::clear()
{
	int i=0;
	for (i=0;i<m_NumItem;i++)
	{
		delete (sdpAttribute*)m_pElements[i];
		m_pElements[i] = NULL;
	}
	m_NumItem=0;
}

void sdpAttributeList::deleteItem(sdpAttribute* a_pAttribute)
{
	if (a_pAttribute)
	{
		sdpElementList::deleteItem(a_pAttribute);
		delete a_pAttribute;
	}
}

sdpAttribute* sdpAttributeList::getItem(int a_Index)
{
	return (sdpAttribute*) sdpElementList::getItem(a_Index);
}
///////////////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////////////
//  class sdpCryptoKeyParmList : public sdpElementList
///////////////////////////////////////////////////////////////////////////////////
sdpCryptoKeyParmList::sdpCryptoKeyParmList()
{
}

sdpCryptoKeyParmList::~sdpCryptoKeyParmList()
{
	clear();
}

sdpCryptoKeyParm* sdpCryptoKeyParmList::addItem()
{
	sdpCryptoKeyParm* pCryptoKeyParm = new sdpCryptoKeyParm;
	sdpElementList::addItem(pCryptoKeyParm);
	return pCryptoKeyParm;
}

void sdpCryptoKeyParmList::addItem(sdpCryptoKeyParm* a_CryptoKeyParm)
{
	sdpElementList::addItem(a_CryptoKeyParm);
	return;
}

void sdpCryptoKeyParmList::clear()
{
	int i=0;
	for (i=0;i<m_NumItem;i++)
	{
		delete (sdpCryptoKeyParm*)m_pElements[i];
		m_pElements[i] = NULL;
	}
	m_NumItem=0;
}

sdpCryptoKeyParm* sdpCryptoKeyParmList::getItem(int a_Index)
{
	return (sdpCryptoKeyParm*) sdpElementList::getItem(a_Index);
}
///////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////
//  class sdpCryptoSessionParmList : public sdpElementList
///////////////////////////////////////////////////////////////////////////////////
sdpCryptoSessionParmList::sdpCryptoSessionParmList()
{
}

sdpCryptoSessionParmList::~sdpCryptoSessionParmList()
{
	clear();
}

sdpCryptoSessionParm* sdpCryptoSessionParmList::addItem()
{
	sdpCryptoSessionParm* pCryptoSessionParm = new sdpCryptoSessionParm;
	sdpElementList::addItem(pCryptoSessionParm);
	return pCryptoSessionParm;
}

void sdpCryptoSessionParmList::addItem(sdpCryptoSessionParm* a_CryptoSessionParm)
{
	sdpElementList::addItem(a_CryptoSessionParm);
	return;
}

void sdpCryptoSessionParmList::clear()
{
	int i=0;
	for (i=0;i<m_NumItem;i++)
	{
		delete (sdpCryptoSessionParm*)m_pElements[i];
		m_pElements[i] = NULL;
	}
	m_NumItem=0;
}

sdpCryptoSessionParm* sdpCryptoSessionParmList::getItem(int a_Index)
{
	return (sdpCryptoSessionParm*) sdpElementList::getItem(a_Index);
}
///////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////
//  class sdpEmailAddressList : public sdpElementList
///////////////////////////////////////////////////////////////////////////////////
sdpEmailAddressList::sdpEmailAddressList()
{
}

sdpEmailAddressList::~sdpEmailAddressList()
{
	clear();
}

sdpEmailAddress* sdpEmailAddressList::addItem()
{
	sdpEmailAddress* pEmailAddress = new sdpEmailAddress;
	sdpElementList::addItem(pEmailAddress);
	return pEmailAddress;
}

void sdpEmailAddressList::clear()
{
	int i=0;
	for (i=0;i<m_NumItem;i++)
	{
		delete (sdpEmailAddress*)m_pElements[i];
		m_pElements[i] = NULL;
	}
	m_NumItem=0;
}

void sdpEmailAddressList::deleteItem(sdpEmailAddress* a_pEmailAddress)
{
	if (a_pEmailAddress)
	{
		sdpElementList::deleteItem(a_pEmailAddress);
		delete a_pEmailAddress;
	}
}

sdpEmailAddress* sdpEmailAddressList::getItem(int a_Index)
{
	return (sdpEmailAddress*) sdpElementList::getItem(a_Index);
}
///////////////////////////////////////////////////////////////////////////////////




///////////////////////////////////////////////////////////////////////////////////
//  class sdpMediaDescriptionList : public sdpElementList
///////////////////////////////////////////////////////////////////////////////////
sdpMediaDescriptionList::sdpMediaDescriptionList()
{
}

sdpMediaDescriptionList::~sdpMediaDescriptionList()
{
	clear();
}

sdpMediaDescription* sdpMediaDescriptionList::addItem()
{
	sdpMediaDescription* pMediaDescription = new sdpMediaDescription;
	sdpElementList::addItem(pMediaDescription);
	return pMediaDescription;
}

void sdpMediaDescriptionList::clear()
{
	int i=0;
	for (i=0;i<m_NumItem;i++)
	{
		delete (sdpMediaDescription*)m_pElements[i];
		m_pElements[i] = NULL;
	}
	m_NumItem=0;
}

void sdpMediaDescriptionList::deleteItem(sdpMediaDescription* a_pMediaDescription)
{
	if (a_pMediaDescription)
	{
		sdpElementList::deleteItem(a_pMediaDescription);
		delete a_pMediaDescription;
	}
}

sdpMediaDescription* sdpMediaDescriptionList::getItem(int a_Index)
{
	return (sdpMediaDescription*) sdpElementList::getItem(a_Index);
}
///////////////////////////////////////////////////////////////////////////////////




///////////////////////////////////////////////////////////////////////////////////
//  class sdpPhoneNumberList : public sdpElementList
///////////////////////////////////////////////////////////////////////////////////
sdpPhoneNumberList::sdpPhoneNumberList()
{
}

sdpPhoneNumberList::~sdpPhoneNumberList()
{
	clear();
}

sdpPhoneNumber* sdpPhoneNumberList::addItem()
{
	sdpPhoneNumber* pPhoneNumber = new sdpPhoneNumber;
	sdpElementList::addItem(pPhoneNumber);
	return pPhoneNumber;
}

void sdpPhoneNumberList::clear()
{
	int i=0;
	for (i=0;i<m_NumItem;i++)
	{
		delete (sdpPhoneNumber*)m_pElements[i];
		m_pElements[i] = NULL;
	}
	m_NumItem=0;
}

void sdpPhoneNumberList::deleteItem(sdpPhoneNumber* a_pPhoneNumber)
{
	if (a_pPhoneNumber)
	{
		sdpElementList::deleteItem(a_pPhoneNumber);
		delete a_pPhoneNumber;
	}
}

sdpPhoneNumber* sdpPhoneNumberList::getItem(int a_Index)
{
	return (sdpPhoneNumber*) sdpElementList::getItem(a_Index);
}
///////////////////////////////////////////////////////////////////////////////////




///////////////////////////////////////////////////////////////////////////////////
//  class sdpTimeDescriptionList : public sdpElementList
///////////////////////////////////////////////////////////////////////////////////
sdpTimeDescriptionList::sdpTimeDescriptionList()
{
}

sdpTimeDescriptionList::~sdpTimeDescriptionList()
{
	clear();
}

sdpTimeDescription* sdpTimeDescriptionList::addItem()
{
	sdpTimeDescription* pTimeDescription = new sdpTimeDescription;
	sdpElementList::addItem(pTimeDescription);
	return pTimeDescription;
}

void sdpTimeDescriptionList::clear()
{
	int i=0;
	for (i=0;i<m_NumItem;i++)
	{
		delete (sdpTimeDescription*)m_pElements[i];
		m_pElements[i] = NULL;
	}
	m_NumItem=0;
}

void sdpTimeDescriptionList::deleteItem(sdpTimeDescription* a_pTimeDescription)
{
	if (a_pTimeDescription)
	{
		sdpElementList::deleteItem(a_pTimeDescription);
		delete a_pTimeDescription;
	}
}

sdpTimeDescription* sdpTimeDescriptionList::getItem(int a_Index)
{
	return (sdpTimeDescription*) sdpElementList::getItem(a_Index);
}
///////////////////////////////////////////////////////////////////////////////////




