/**
* @file bridgedhairpdisconnecting_state.cpp
* @brief Definition of BridgedHairpDisconnectingState class
* @date Feb. 16, 2007
*
* DIALOGIC CONFIDENTIAL
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#include "bridgedhairpdisconnecting_state.h"
#include "bridgedhairp.h"
#include "endpointmgr.h"
#include "logger.h"
#include "appevents.h"

//*****************************************************************************
// Function: BridgedHairpDisconnectingState::BridgedHairpDisconnectingState(BridgedHairp *pBridgedHairp)
// Description: Initializing constructor
// Return:  BridgedHairpDisconnectingState*
// Parameters: BridgedHairp *pBridgedHairp 
//*****************************************************************************
BridgedHairpDisconnectingState::BridgedHairpDisconnectingState(BridgedHairp* pBridgedHairp) :
   BridgedHairpState(pBridgedHairp)
{
}


//*****************************************************************************
// Function: BridgedHairpDisconnectingState::~BridgedHairpDisconnectingState()
// Description: Default Destructor
// Return:  none
// Parameters: none 
//*****************************************************************************
BridgedHairpDisconnectingState::~BridgedHairpDisconnectingState()
{
}

//*****************************************************************************
// Function: void BridgedHairpDisconnectingState::ProcessEvent(METAEVENT metaevent)
// Description: Process an event
// Return: none
// Parameters: METAEVENT metaevent 
//*****************************************************************************
void BridgedHairpDisconnectingState::ProcessEvent(METAEVENT metaevent)
{
   switch ( metaevent.evttype )
   {
      case APP_M3G_ENDPOINT_DISCONNECTED:
         LOG_ENTRY(metaevent.evtdev, "BridgedHairp[%d] BridgedHairpDisconnectinState rcvd:APP_M3G_ENDPOINT_DISCONNECTED\n",m_pBridgedHairp->Index());
         ProcessEndpointDisconnected(metaevent);
         break;

      case APP_M3G_ENDPOINT_DISCONNECT:
         LOG_ENTRY(metaevent.evtdev, "BridgedHairp[%d] BridgedHairpDisconnectinState rcvd:APP_M3G_ENDPOINT_DISCONNECT - ignored\n",m_pBridgedHairp->Index());
         break;

      default:
         LOG_ERROR(metaevent.evtdev,
            "BridgedHairp[%d] BridgedHairpDisconnectinState: Unexpected event type: 0x%x\n",
            m_pBridgedHairp->Index(),metaevent.evttype); 
         break;
   }
}


//*****************************************************************************
// Function: void BridgedHairpDisconnectingState::ProcessEndpointDisconnected(METAEVENT metaevent)
// Description: Process endpoint disconnected event
// Return: void 
// Parameters: METAEVENT metaevent 
//*****************************************************************************
void BridgedHairpDisconnectingState::ProcessEndpointDisconnected(METAEVENT metaevent)
{
  // if this is the caller, reset its index
  if (m_pBridgedHairp->CallerIndex() == (*(int *)metaevent.evtdatap))
  {
     m_pBridgedHairp->ClearCallerIndex();
  }
  else // else reset the callee index
  {
     m_pBridgedHairp->ClearCalleeIndex();
  }

  if (m_pBridgedHairp->IsHairPinDisconnected())
  {
    m_pBridgedHairp->ChangeState(IDLE_STATE);
  }
}


