/**
* @file bridgedmediaopening_state.cpp
* @brief Definition of BridgedMediaOpeningState class
* @date Feb. 16, 2007
*
* DIALOGIC CONFIDENTIAL
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#include "bridgedmediaopening_state.h"
#include "bridgedmedia.h"
#include "endpointmgr.h"
#include "logger.h"
#include "appevents.h"

// static constant members:
const int BridgedMediaOpeningState::MM_OPENED             = 0x01;
const int BridgedMediaOpeningState::M3G_OPENED            = 0x02;
const int BridgedMediaOpeningState::BOTH_OPENED           = 0x03;
const int BridgedMediaOpeningState::MM_CONNECTED          = 0x10;
const int BridgedMediaOpeningState::M3G_CONNECTED         = 0x20;
const int BridgedMediaOpeningState::BOTH_CONNECTED        = 0x30;

//*****************************************************************************
// Function: BridgedMediaOpeningState::BridgedMediaOpeningState(BridgedMedia *pBridgedMedia)
// Description: Initializing constructor
// Return:  BridgedMediaOpeningState*
// Parameters: BridgedMedia *pBridgedMedia 
//*****************************************************************************
BridgedMediaOpeningState::BridgedMediaOpeningState(BridgedMedia* pBridgedMedia)
   : BridgedMediaState(pBridgedMedia)
{
}

//*****************************************************************************
// Function: BridgedMediaOpeningState::~BridgedMediaOpeningState()
// Description: Descructor
// Return:  none
// Parameters: none 
//*****************************************************************************
BridgedMediaOpeningState::~BridgedMediaOpeningState()
{
}

//*****************************************************************************
// Function: void BridgedMediaOpeningState::ProcessEvent(METAEVENT metaevent)
// Description: Process an event
// Return: none
// Parameters: METAEVENT metaevent 
//*****************************************************************************
void BridgedMediaOpeningState::ProcessEvent(METAEVENT metaevent)
{
   switch ( metaevent.evttype )
   {
      case APP_MM_ENDPOINT_OPENED:
         LOG_ENTRY(metaevent.evtdev, "BridgedMedia[%d] BridgedMediaOpeningState rcvd:APP_MM_ENDPOINT_OPENED\n", m_pBridgedMedia->Index());
         SetStatus(MM_OPENED);
         ProcessEndpointOpened(metaevent);
         break;
      case APP_M3G_ENDPOINT_OPENED:
         LOG_ENTRY(metaevent.evtdev, "BridgedMedia[%d] BridgedMediaOpeningState rcvd:APP_M3G_ENDPOINT_OPENED\n", m_pBridgedMedia->Index());
         SetStatus(M3G_OPENED);
         ProcessEndpointOpened(metaevent);
         break;
      case APP_MM_ENDPOINT_PORT_CONNECTED:
         LOG_ENTRY(metaevent.evtdev, "BridgedMedia[%d] BridgedMediaOpeningState rcvd:APP_MM_ENDPOINT_PORT_CONNECTED\n", m_pBridgedMedia->Index());
         SetStatus(MM_CONNECTED);
         ProcessEndpointConnected(metaevent);
         break;
      case APP_M3G_ENDPOINT_PORT_CONNECTED:
         LOG_ENTRY(metaevent.evtdev, "BridgedMedia[%d] BridgedMediaOpeningState rcvd:APP_M3G_ENDPOINT_PORT_CONNECTED\n", m_pBridgedMedia->Index());
         SetStatus(M3G_CONNECTED);
         ProcessEndpointConnected(metaevent);
         break;
      default:
         LOG_ERROR(metaevent.evtdev,"BridgedMedia[%d] BridgedMediaOpeningState: Unexpected event type: 0x%x\n", 
		   m_pBridgedMedia->Index(),metaevent.evttype);
         break;
   }
}

//*****************************************************************************
// Function: void BridgedMediaOpeningState::ProcessEndpointOpened(METAEVENT metaevent)
// Description: Process endpoint opened event
// Return: void 
// Parameters: METAEVENT metaevent 
//*****************************************************************************
void BridgedMediaOpeningState::ProcessEndpointOpened(METAEVENT metaevent)
{
   if ( IsBridgedMediaOpened() )
   {
      // send commands to MM and M3G endpoints to connect to each other
      MMEndpoint *pMMEndpoint = EndpointMngr::Instance()->GetMMEPFromIdx( m_pBridgedMedia->MMIndex());
      Endpoint *pEndpoint = EndpointMngr::Instance()->GetEPFromIdx( m_pBridgedMedia->M3gIndex());

      if ( pMMEndpoint && pEndpoint )
      {
         pEndpoint->ConnectToPeer(pMMEndpoint->GetAudioRxPortInfo(), pMMEndpoint->GetVideoRxPortInfo());
         pMMEndpoint->ConnectToPeer(pEndpoint->GetAudioRxPortInfo(), pEndpoint->GetVideoRxPortInfo());
      }
      else
      {
         LOG_ERROR(0,"BridgedMedia[%d] Endpoint(s) not found\n",m_pBridgedMedia->Index());
      }
   }
}

//*****************************************************************************
// Function: void BridgedMediaOpeningState::ProcessEndpointConnected(METAEVENT metaevent)
// Description: Process endpoint port connected event
// Return: void 
// Parameters: METAEVENT metaevent 
//*****************************************************************************
void BridgedMediaOpeningState::ProcessEndpointConnected(METAEVENT metaevent)
{
   if ( IsBridgedMediaConnected() )
   {
      m_pBridgedMedia->ChangeState(IDLE_STATE);
   }
}
