/**
* @file bridgedmediarecording_state.cpp
* @brief Definition of BridgedMediaRecordingState class
* @date Feb. 16, 2007
*
* DIALOGIC CONFIDENTIAL
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#include "bridgedmediarecording_state.h"
#include "bridgedmedia.h"
#include "endpointmgr.h"
#include "logger.h"
#include "appevents.h"
#include "epstate.h"

// static constant members
const int BridgedMediaRecordingState::M3G_DISCONNECTED = 0x1;

//*****************************************************************************
// Function: BridgedMediaRecordingState::BridgedMediaRecordingState(BridgedMedia *pBridgedMedia)
// Description: Initializing constructor
// Return:  BridgedMediaRecordingState*
// Parameters: BridgedMedia *pBridgedMedia 
//*****************************************************************************
BridgedMediaRecordingState::BridgedMediaRecordingState(BridgedMedia* pBridgedMedia) :
   BridgedMediaState(pBridgedMedia)
{
}


//*****************************************************************************
// Function: BridgedMediaRecordingState::~BridgedMediaRecordingState()
// Description: Destructor
// Return:  none
// Parameters: none 
//*****************************************************************************
BridgedMediaRecordingState::~BridgedMediaRecordingState()
{
}

//*****************************************************************************
// Function: void BridgedMediaRecordingState::ProcessEvent(METAEVENT metaevent)
// Description: Process an event
// Return: none
// Parameters: METAEVENT metaevent 
//*****************************************************************************
void BridgedMediaRecordingState::ProcessEvent(METAEVENT metaevent)
{
   switch ( metaevent.evttype )
   {
      case APP_M3G_ENDPOINT_DISCONNECT:
      LOG_ENTRY(metaevent.evtdev, "BridgedMedia[%d] BridgedMediaRecordingState rcvd:APP_M3G_ENDPOINT_DISCONNECT\n",m_pBridgedMedia->Index());
      break;
      case APP_M3G_ENDPOINT_DISCONNECTED:
      LOG_ENTRY(metaevent.evtdev, "BridgedMedia[%d] BridgedMediaRecordingState rcvd:APP_M3G_ENDPOINT_DISCONNECTED\n",m_pBridgedMedia->Index());
      SetStatus(M3G_DISCONNECTED);
      Process3GDisconnected(metaevent);
      break;
      case APP_MM_ENDPOINT_DISCONNECTED: 
      LOG_ENTRY(metaevent.evtdev, "BridgedMedia[%d] BridgedMediaRecordingState rcvd:APP_MM_ENDPOINT_DISCONNECTED\n",m_pBridgedMedia->Index());
      break;
      case APP_MM_ENDPOINT_IDLE:
      LOG_ENTRY(metaevent.evtdev, "BridgedMedia[%d] BridgedMediaRecordingState rcvd:APP_MM_ENDPOINT_IDLE\n",m_pBridgedMedia->Index());
      // MM play has terminated
      ProcessMediaDone(metaevent);
      break;
      default:
	LOG_ERROR(metaevent.evtdev,"BridgedMedia[%d] BridgedMediaRecordingState: Unexpected event type: 0x%x\n",
		   m_pBridgedMedia->Index(),metaevent.evttype);
         break;
   }
}

//*****************************************************************************
// Function: void BridgedMediaRecordingState::ProcessMMRecording(METAEVENT metaevent)
// Description: Process an MM recording  event
// Return: void 
// Parameters: METAEVENT metaevent 
//*****************************************************************************
void BridgedMediaRecordingState::ProcessMediaDone(METAEVENT metaevent)
{
   char mRecordAudioFileName[FNAME_SIZE];
   char mRecordVideoFileName[FNAME_SIZE];

   MMEndpoint *pMMEndpoint = EndpointMngr::Instance()->GetMMEPFromIdx( m_pBridgedMedia->MMIndex());

   // Done recording, so replay the file if still 3G Connected
   if ( pMMEndpoint && !IsBridgedMedia3GDisconnected())   
   { 
     m_pBridgedMedia->ChangeState(IDLE_STATE);
     //sprintf(mRecordAudioFileName,"%s_%d.aud",EndpointMngr::Instance()->GetMMRecordAudioFileName(pMMEndpoint->GetLastDigitRcvd()),pMMEndpoint->GetIndex());
     //sprintf(mRecordVideoFileName,"%s_%d.vid",EndpointMngr::Instance()->GetMMRecordVideoFileName(pMMEndpoint->GetLastDigitRcvd()),pMMEndpoint->GetIndex());
     sprintf(mRecordAudioFileName,"%s",EndpointMngr::Instance()->GetMMRecordAudioFileName(pMMEndpoint->GetLastDigitRcvd()));
     sprintf(mRecordVideoFileName,"%s",EndpointMngr::Instance()->GetMMRecordVideoFileName(pMMEndpoint->GetLastDigitRcvd()));
     pMMEndpoint->PlayVideoFile(mRecordAudioFileName,mRecordVideoFileName);
     // SetLastDigitRcvd to NULL after play recorded file 
     pMMEndpoint->SetLastDigitRcvd(char(NULL));
   }
   else
   {
     m_pBridgedMedia->ChangeState(IDLE_STATE);
   }

}

//*****************************************************************************
// Function: void BridgedMediaRecordingState::Process3GDisconnected(METAEVENT metaevent)
// Description: Process an 3G Disconnected event
// Return: void 
// Parameters: METAEVENT metaevent 
//*****************************************************************************
void BridgedMediaRecordingState::Process3GDisconnected(METAEVENT metaevent)
{
  // Want to stop the record in progress
  MMEndpoint *pMMEndpoint = EndpointMngr::Instance()->GetMMEPFromIdx( m_pBridgedMedia->MMIndex());
  if (pMMEndpoint)  {
    pMMEndpoint->StopMMRecord();
  }
}

