/**
* @file connecting_state.h
* @brief Declaration of ConnectingState class
* @date Feb. 16, 2007
*
* DIALOGIC CONFIDENTIAL
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#ifndef  _CONNECTING_STATE_H
#define  _CONNECTING_STATE_H

#include "epstate.h"

//*****************************************************************************
// Class: ::ConnectingState
// Description: This EPState subclass handles the connecting of devices DSO 
//              timeslots and PStream ports via dev_Connect and dev_PortConnect
//              APIs.  Endpoints are connected to the DSO timeslt via 
//              dev_Connect( ) to the DTI device and to their 3G bridging peers
//              via dev_PortConnect( ) once all port information is retrieved.
//*****************************************************************************
class ConnectingState : public EPState
{
public:
   ConnectingState(Endpoint* pEndpoint);
   ~ConnectingState();
   virtual void ProcessEvent(long  evtType, void *pEvtData, long  evtLen, long  evtDev);
   virtual void ProcessUserPrompt(EPState::E_USER_PROMPT_TYPE eUserPrompt);
   virtual void Shutdown();
   virtual const char *GetStateStr() { return "CONNECTING     ";}
   virtual E_EPSTATE GetState() { return CONNECTING_STATE;}
   void ProcessDeviceConnect(long evtDev);
   bool IsEndpointAllPortsRcvd() { return(IsStatusSet(MEDIA_PORTS_RCVD));}

private:
   static const int AUDIO_TX_PORTS_RCVD; // 0x01
   static const int AUDIO_RX_PORTS_RCVD; // 0x02
   static const int VIDEO_TX_PORTS_RCVD; // 0x04
   static const int VIDEO_RX_PORTS_RCVD; // 0x08
   static const int MEDIA_PORTS_RCVD;    // 0x0F

   static const int NETWORK_CONNECTED;   // 0x10
   static const int CONTROL_CONNECTED;   // 0x20
   static const int AUDIO_CONNECTED;     // 0x40
   static const int VIDEO_CONNECTED;     // 0x80
   static const int LOOPBACK_CONNECTED;  // 0xE0
   static const int M3G_CONNECTED;       // 0xE0
   static const int FULLY_CONNECTED;     // 0xF0

    // Nbup mask values
   static const int NBUP_3G_TX_PORTS_RCVD;   // 0x1000
   static const int NBUP_3G_RX_PORTS_RCVD;   // 0x2000
   static const int NBUP_IPM_TX_PORTS_RCVD;  // 0x4000
   static const int NBUP_IPM_RX_PORTS_RCVD;  // 0x8000
   static const int ALL_NBUP_PORTS_RCVD;     // 0xF000

   bool IsEndpointFullyConnected();
   void CheckToInitPortConnection();
   void ProcessResetComplete();
   void CheckToInitNbupPortConnection();
};

#endif


