/**
* @file epstate.h
* @brief Declaration of EPState class
* @date Feb. 16, 2007
*
* DIALOGIC CONFIDENTIAL
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#ifndef  _EPSTATE_H
#define  _EPSTATE_H

#include "m3glib.h"
#include "statusbitmask.h"

class Endpoint;

//*****************************************************************************
// Class: ::EPState
// Description: Base calss for all 3G endpoint state classes
//*****************************************************************************
class EPState : public StatusBitmask
{
public:


   typedef enum
   {
      NULL_STATE,
      OPENING_STATE,
      CONNECTING_STATE,
      H245_INACTIVE_STATE,
      H245_STARTING_STATE,
      OPENING_LCS_STATE,
      MEDIA_ACTIVE_STATE,
      RX_MEDIA_STOPPED_STATE,  // used in hair-pinning only
      CLOSING_LCS_STATE,
      NUM_EP_STATES
   }  E_EPSTATE;

   typedef enum
   {
      USER_CONNECT_PROMPT,
      USER_DISCONNECT_PROMPT,
      USER_SEND_DIGIT_PROMPT,
      USER_SEND_FVU_PROMPT
   }  E_USER_PROMPT_TYPE;

   // static constant
   static const int CHANNEL_STATUS;     // 0xFFF00000
   static const int AUDIO_TX_STARTING;  // 0x01000000
   static const int AUDIO_RX_STARTING;  // 0x02000000
   static const int VIDEO_TX_STARTING;  // 0x04000000
   static const int VIDEO_RX_STARTING;  // 0x08000000
   static const int AUDIO_CHANS_STARTED;// 0x33000000
   static const int VIDEO_CHANS_STARTED;// 0xCC000000

   EPState(Endpoint* pEndpoint);
   virtual ~EPState();
   virtual void ProcessEvent(long  evtType, void *pEvtData, long  evtLen, long  evtDev) = 0;
   virtual void ProcessUserPrompt(EPState::E_USER_PROMPT_TYPE eUserPrompt) = 0;
   virtual void Shutdown() = 0;
   virtual E_EPSTATE GetState() = 0;
   virtual bool IsEndpointAllPortsRcvd() { return false;}  // overridden in connecting state
   int GetChannelStatus() { return (m_StatusBitmask & CHANNEL_STATUS);}

protected:
   // media channel related logic used in both derived h245Starting and OpeningLCs states
   static const int AUDIO_TX_LCN_OPEN;  // 0x00100000
   static const int AUDIO_RX_LCN_OPEN;  // 0x00200000
   static const int VIDEO_TX_LCN_OPEN;  // 0x00400000
   static const int VIDEO_RX_LCN_OPEN;  // 0x00800000
   static const int AUDIO_TX_ACTIVE;    // 0x10000000
   static const int AUDIO_RX_ACTIVE;    // 0x20000000
   static const int VIDEO_TX_ACTIVE;    // 0x40000000
   static const int VIDEO_RX_ACTIVE;    // 0x80000000
   static const int ALL_CHANNELS_ACTIVE;// 0xF0000000


   void ActivateAudioChannel(M3G_E_DIRECTION direction, M3G_LOGICAL_CHANNEL_NUMBER lcn);
   void ActivateVideoChannel(M3G_E_DIRECTION direction, M3G_LOGICAL_CHANNEL_NUMBER lcn);
   bool IsAudioStarted() { return (IsStatusSet(AUDIO_TX_LCN_OPEN) || IsStatusSet(AUDIO_RX_LCN_OPEN));}
   bool IsVideoStarted() { return (IsStatusSet(VIDEO_TX_LCN_OPEN) || IsStatusSet(VIDEO_RX_LCN_OPEN));}
   void CheckAllChannelsActive();

   Endpoint *m_pEndpoint;
};

#endif

