/**
* @file h245starting_state.h
* @brief Declaration of H245StartingState class
* @date Feb. 16, 2007
*
* DIALOGIC CONFIDENTIAL
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#ifndef  _H245STARTING_STATE_H
#define  _H245STARTING_STATE_H

#include "epstate.h"

//*****************************************************************************
// Class: ::H245StartingState
// Description: This EPState subclass initiates the H.245 (and H.223) layers
//              and completes once the H.223 framing is established and both 
//              MSD and TCS sets of transactions are completed
//*****************************************************************************
class H245StartingState : public EPState
{
public:
   H245StartingState(Endpoint* pEndpoint);
   virtual ~H245StartingState();
   virtual void ProcessEvent(long  evtType, void *pEvtData, long  evtLen, long  evtDev);
   virtual void ProcessUserPrompt(EPState::E_USER_PROMPT_TYPE eUserPrompt);
   virtual void Shutdown();
   virtual const char *GetStateStr() { return "H245_STARTING   ";}
   virtual E_EPSTATE GetState() { return H245_STARTING_STATE;}

private:
   static const int H245_STARTED;     // 0x01
   static const int FRAMING_EST;      // 0x02
   static const int MSD_CMPLT;        // 0x04
   static const int REMOTE_TCS_RCVD;  // 0x08
   static const int LOCAL_TCS_ACKD;   // 0x10
   static const int H245_READY;       // 0x1F

   void ProcessResetComplete();
   void CheckH245ReadyToStartChans();
   void StopSession();
};

#endif


