/**
*
* DIALOGIC CONFIDENTIAL
* Copyright � 2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#ifndef  _ISDNENDPOINT_H
#define  _ISDNENDPOINT_H

#include "gclib.h"

#include "baseendpoint.h"
#include "endpoint.h"
#include "isdnepstate.h"
#include "isdnopening_state.h"
#include "isdnwaitcall_state.h"
#include "isdnaccepted_state.h"
#include "isdnconnected_state.h"
#include "isdndropping_state.h"
#include "isdncalling_state.h"
#include "isdnproceeding_state.h"
#include "isdnreleasing_state.h"
#include "isdnendpoint.h"

#include <time.h>
#include "locker.h"


class Endpoint;

//*****************************************************************************
// Class: ::ISDNEndpoint
// Description: This is the ISDN endpoint class
//*****************************************************************************
class ISDNEndpoint : public BaseEndpoint
{
public:
#ifdef ISDN_CALL_OUT
   ISDNEndpoint(int numEP, const char *ISDNName, Endpoint *pEndpoint, T_ENDPOINT type, const char *dialString);
#else
   ISDNEndpoint(int numEP, const char *ISDNName, Endpoint *pEndpoint, T_ENDPOINT type);
#endif
   ~ISDNEndpoint();

   void ProcessEvent(METAEVENT metavent);
   ISDNEPState::E_ISDNEPSTATE GetState();
   char *GetStateString();
   void OpenSubDevs();
   //Actions
   void SetNetWorkHandle();
   void SendConnected(bool connected);
   bool WaitCall();
   bool ResetLineDev();
   bool AnswerCall(CRN crn);
   bool DropCall();
   bool ReleaseCall();
   void MakeCall();
   void SetBearerCap();
   void LogGlobalCallError();
   void Shutdown() { if ( m_pCurrentState ) m_pCurrentState->Shutdown();}
   void CloseSubDevs();
   LINEDEV GetGCISDNHandle() { return m_GCISDNHandle;}

   void ChangeState(ISDNEPState::E_ISDNEPSTATE e_NewState);
   void SetLastMessageString(char *pMessageStr);
   void LogDevError();
   int GetIndex() { return m_Index;}


private:
   int                        m_Index;
   time_t                     m_ConnectionTime;


   ISDNEPState                *m_pISDNOpeningState;
   ISDNEPState                *m_pISDNWaitCallState;
   ISDNEPState                *m_pISDNAcceptedState;
   ISDNEPState                *m_pISDNConnectedState;
   ISDNEPState                *m_pISDNDroppingState;
   ISDNEPState                *m_pISDNCallingState;
   ISDNEPState                *m_pISDNProceedingState;
   ISDNEPState                *m_pISDNReleasingState;
   ISDNEPState                *m_pISDNAlarmState;
   ISDNEPState                *m_pCurrentState;

   char                       m_ISDNName[DEV_NAME_SIZE];
   Endpoint                   *m_Endpoint;
   LINEDEV                    m_GCISDNHandle;
   char                       m_StateBuffer[MAX_STATE_STRING];
   char                       m_LastMessageBuff[MAX_LAST_MSG_STRING];
   CRN                        m_CRN;

   char                       m_CurrentStateStr[MAX_CURRENT_STATE_STR];
   CLocker                    m_StateLock;

#ifdef ISDN_CALL_OUT
   char                       m_DialString[LINE_BUFFER_SIZE];
#endif
};

#endif


