/**
*
* DIALOGIC CONFIDENTIAL
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#ifndef  _ISDNPROCEEDING_STATE_H
#define  _ISDNPROCEEDING_STATE_H

#include "isdnepstate.h"


//*****************************************************************************
// Class: ::ISDNProceedingState
// Description: This ISDNEPState subclass handles the opening of ISDN endpoint
//*****************************************************************************
class ISDNProceedingState : public ISDNEPState
{
public:
   ISDNProceedingState(ISDNEndpoint* pISDNEndpoint);
   ~ISDNProceedingState();
   virtual void ProcessEvent(METAEVENT metaevent);
   virtual void Shutdown();
   virtual const char *GetStateStr() { return "PROCEEDING";}
   virtual E_ISDNEPSTATE GetState() { return PROCEEDING_STATE;}
};

#endif


