/**
* @file logger.h
* @brief Declaration of Logger class
* @date Feb. 16, 2007
*
* DIALOGIC CONFIDENTIAL
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#ifndef  _LOGGER_H
#define  _LOGGER_H

#include "m3glib.h"
#include <stdio.h>

#define BOOL_STRINGIFY(x)  (x) ? "true" : "false"
#define LOG_ENTRY          EndpointMngr::Instance()->GetLogger()->LogEntry
#define LOG_ERROR          EndpointMngr::Instance()->GetLogger()->LogError

//*****************************************************************************
// Class: ::Logger
// Description: Log all application messages and errors
//*****************************************************************************
class Logger
{
public:

   Logger(const char *logFileName, bool& isOpened);
   ~Logger();
   void LogEntry(SRL_DEVICE_HANDLE dev, const char *fmt, ...);
   void LogError(SRL_DEVICE_HANDLE dev, const char *errStr, ...);
   void SetLoggingEnabled(bool enabled) { m_IsEnabled = enabled;}

private:
   FILE *m_FileHandle;
   bool m_IsEnabled;
};

#endif

