/**
* @file mmopening_state.h
* @brief Declaration of MMOpeningState class
* @date Feb. 20, 2007
*
* DIALOGIC CONFIDENTIAL
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#ifndef  _MMOPENING_STATE_H
#define  _MMOPENING_STATE_H

#include "mmepstate.h"


//*****************************************************************************
// Class: ::MMOpeningState
// Description: This MMEPState subclass handles the opening of MM endpoint
//*****************************************************************************
class MMOpeningState : public MMEPState
{
public:
   MMOpeningState(MMEndpoint* pMMEndpoint);
   ~MMOpeningState();
   virtual void ProcessEvent(METAEVENT metaevent);
   virtual void Shutdown();
   virtual const char *GetStateStr() { return "OPENING        ";}
   virtual E_MMEPSTATE GetState() { return OPENING_STATE;}
   void ProcessDeviceOpen(METAEVENT metaevent);
   void SetStatus(int status) { m_StatusBitmask |= status;}

private:
   void ProcessTxPortInfo(METAEVENT metaevent);
   void ProcessRxPortInfo(METAEVENT metaevent);
   void ProcessMMOpen(METAEVENT metaevent);
   static const int TX_PORTS_RCVD;     // 0x01
   static const int RX_PORTS_RCVD;     // 0x02
   static const int MMEP_OPENED;       // 0x04
   static const int MMEP_READY;        // 0x07

   bool IsMMEndpointReady() { return (IsStatusSet(MMEP_READY));}
};

#endif


