/**
* @file mmrecording_state.cpp
* @brief Definition of MMRecordingState class
* @date Feb. 20, 2007
*
* DIALOGIC CONFIDENTIAL
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#include "mmlib.h"
#include "mmrecording_state.h"
#include "mmendpoint.h"
#include "endpointmgr.h"
#include "logger.h"

#include "appevents.h"

//*****************************************************************************
// Function: MMRecordingState::MMRecordingState(MMEndpoint *pMMEndpoint)
// Description: Initializing constructor
// Return:  MMRecordingState*
// Parameters: MMEndpoint *pMMEndpoint 
//*****************************************************************************
MMRecordingState::MMRecordingState(MMEndpoint* pMMEndpoint) :
   MMEPState(pMMEndpoint)
{
}

//*****************************************************************************
// Function: MMRecordingState::~MMRecordingState()
// Description: Destructor
// Return:  none
// Parameters: none 
//*****************************************************************************
MMRecordingState::~MMRecordingState()
{
}

//*****************************************************************************
// Function: void MMRecordingState::ProcessEvent(METAEVENT metaevent)
// Description: Process an event
// Return: none 
// Parameters: METAEVENT metaevent 
//*****************************************************************************
void MMRecordingState::ProcessEvent(METAEVENT metaevent)
{
   switch ( metaevent.evttype )
   {
    case M3GEV_H245_UII_RCVD:
      LOG_ENTRY(metaevent.evtdev, "Event M3GEV_H245_UII_RCVD received\n");
      // This event is a little odd, as it has arrived at this MM endpoints 3G peer.  But
      // might as well use it as any other event value for UII/DTMF notification.
       ProcessUIIRcvd(metaevent);
        break;
    case MMEV_RECORD_ACK:
      LOG_ENTRY(metaevent.evtdev, "Event MMEV_RECORD_ACK received\n");
        break;
    case MMEV_STOP_ACK:
      LOG_ENTRY(metaevent.evtdev, "Event MMEV_STOP_ACK received\n");
        break;
    case MMEV_RECORD:
      LOG_ENTRY(metaevent.evtdev, "Event MMEV_RECORD received\n");
      ProcessRecordDone(metaevent);
        break;
    case MMEV_VIDEO_RECORD_STARTED:
      LOG_ENTRY(metaevent.evtdev, "Event MMEV_VIDEO_RECORD_STARTED received\n");
        break;
    case MMEV_RECORD_ACK_FAIL:
      LOG_ENTRY(metaevent.evtdev, "Event MMEV_RECORD_FAIL_ACK received\n");
        break;
    case MMEV_STOP_ACK_FAIL:
      LOG_ENTRY(metaevent.evtdev, "Event MMEV_STOP_FAIL_ACK received\n");
        break;
      default:
         LOG_ERROR(metaevent.evtdev, "MMRecording state: Unexpected event type: 0x%x\n",
		   metaevent.evttype);
         break;
   }
}

void MMRecordingState::ProcessUIIRcvd(METAEVENT metaevent)
{
  char *UIIPtr = (char *) metaevent.evtdatap;

  // Simple here - any UII/DTMF triggers a mm_Stop to terminate recording.
  LOG_ENTRY(metaevent.evtdev, "UII %c received - terminating recording\n", *UIIPtr);
  m_pMMEndpoint->StopMMRecord();
} 


void MMRecordingState::ProcessRecordDone(METAEVENT metaevent)
{
      //  Recording is finish; change MM endpoint state and let Bridged Media object know
      m_pMMEndpoint->ChangeState(IDLE_STATE);
      m_pMMEndpoint->Notify(APP_MM_ENDPOINT_IDLE);
}
 
//*****************************************************************************
// Function: void MMRecordingState::Shutdown()
// Description: Process shutdown request
// Return: void 
// Parameters: none 
//*****************************************************************************
void MMRecordingState::Shutdown()
{
  LOG_ENTRY(m_pMMEndpoint->GetMMHandle(), "Shutdown called in %s state.  No Op\n", GetStateStr());
}

