/**
* @file mmplaying_state.h
* @brief Declaration of RTSPPlayingState class
* @date Feb. 20, 2007
*
* DIALOGIC CONFIDENTIAL
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#ifndef  _RTSPPLAYING_STATE_H
#define  _RTSPPLAYING_STATE_H

#include "rtspepstate.h"

//*****************************************************************************
// Class: ::RTSPPlayingState
// Description: This RTSPEPState subclass handles the playing of RTSP endpoint
//*****************************************************************************
class RTSPPlayingState : public RTSPEPState
{
public:
   RTSPPlayingState(RTSPEndpoint* pRTSPEndpoint);
   ~RTSPPlayingState();
   virtual void ProcessEvent(METAEVENT metaevent);
   virtual void Shutdown();
   virtual const char *GetStateStr() { return "PLAYING        ";}
   virtual E_RTSPEPSTATE GetState() { return PLAYING_STATE;}

private:
void ProcessPlayDone(METAEVENT metaevent);
void ProcessPlayStopAckRcvd(METAEVENT metaevent);
void ProcessUIIRcvd(METAEVENT metaevent);

};

#endif


