/**
* @file mmrecording_state.h
* @brief Declaration of RTSPRecordingState class
* @date Feb. 20, 2007
*
* DIALOGIC CONFIDENTIAL
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#ifndef  _RTSPRECORDING_STATE_H
#define  _RTSPRECORDING_STATE_H

#include "rtspepstate.h"

//*****************************************************************************
// Class: ::RTSPRecordingState
// Description: This RTSPEPState subclass handles the recording of RTSP endpoint
//*****************************************************************************
class RTSPRecordingState : public RTSPEPState
{
public:
   RTSPRecordingState(RTSPEndpoint* pRTSPEndpoint);
   ~RTSPRecordingState();
   virtual void ProcessEvent(METAEVENT metaevent);
   virtual void Shutdown();
   virtual const char *GetStateStr() { return "RECORDING        ";}
   virtual E_RTSPEPSTATE GetState() { return RECORDING_STATE;}

private:
  void ProcessRecordDone(METAEVENT metaevent);
  void ProcessUIIRcvd(METAEVENT metaevent);

};

#endif


