/**
* @file sipclosed_state.cpp
* @brief Definition of SIPClosedState class
* @date Feb. 20, 2007
*
* DIALOGIC CONFIDENTIAL
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#include "ipmlib.h"
#include "sipclosed_state.h"
#include "sipoffered_state.h"
#include "sipendpoint.h"
#include "endpointmgr.h"
#include "appevents.h"
#include "logger.h"

//*****************************************************************************
// Function: SIPClosedState::SIPClosedState(SIPEndpoint *pSIPEndpoint)
// Description: Initializing constructor
// Return:  SIPClosedState*
// Parameters: SIPEndpoint *pSIPEndpoint 
//*****************************************************************************
SIPClosedState::SIPClosedState(SIPEndpoint* pSIPEndpoint):
   SIPEPState(pSIPEndpoint)
{
   m_pSIPEndpoint = pSIPEndpoint;
}


//*****************************************************************************
// Function: SIPClosedState::~SIPClosedState()
// Description: Destructor
// Return:  none
// Parameters: none 
//*****************************************************************************
SIPClosedState::~SIPClosedState()
{
}

//*****************************************************************************
// Function: void SIPClosedState::ProcessEvent(METAEVENT metaevent)
// Description: Process an event
// Return: none
// Parameters: METAEVENT metaevent 
//*****************************************************************************
void SIPClosedState::ProcessEvent(METAEVENT metaevent)
{
   switch ( metaevent.evttype )
   {
      default:
         LOG_ERROR(metaevent.evtdev,"SIPClosedState: Unexpected event type: 0x%x\n", metaevent.evttype);
         break;
   }
}

//*****************************************************************************
// Function: void SIPClosedState::ProcessUserPrompt(SIPEPState::E_USER_PROMPT_TYPE eUserPrompt)
// Description: Process a request from the user interface
// Return: void 
// Parameters: SIPEPState::E_USER_PROMPT_TYPE eUserPrompt 
//*****************************************************************************
void  SIPClosedState::ProcessUserPrompt(SIPEPState::E_USER_PROMPT_TYPE eUserPrompt)
{
   LOG_ERROR(0,"Unexpected user prompt on SIP endpoint in CLOSED state: %d\n",
             static_cast<int>(eUserPrompt));
}


//*****************************************************************************
// Function: void SIPClosedState::Shutdown()
// Description: Process shutdown request
// Return: void 
// Parameters: none 
//*****************************************************************************
void SIPClosedState::Shutdown()
{
  LOG_ENTRY(m_pSIPEndpoint->GetGCSIPHandle(), "Shutdown called in %s state.  No op\n", GetStateStr());
}

