/**
* @file sipreleasing_state.cpp
* @brief Definition of SIPReleasingState state
* @date Feb. 20, 2007
*
* DIALOGIC CONFIDENTIAL
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/
/******************************************************************************
* SIPRELEASING_STATE.H: Declaration of IdleState class for SIP endpoints.  This 
* SIPEPState subclass handles the eventing in a SIP endpoint ready to make 
* or receive a call.
*******************************************************************************
* DIALOGIC CONFIDENTIAL	
* Copyright 2006 Dialogic Inc. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to 
* the source code ("Material") are owned by Dialogic Inc. or its suppliers
* or licensors.  Title to the Material remains with Dialogic Inc. or its 
* suppliers and licensors.  The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors.  The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions.  No part of the Material may be used, copied, reproduced, 
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual 
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise.  Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
* 
* Unless otherwise agreed by Dialogic in writing, you may not remove or alter this
* notice or any other notice embedded in Materials by Dialogic or Dialogic's 
* suppliers or licensors in any way.
*********************************************************************/

#include "ipmlib.h"
#include "sipreleasing_state.h"
#include "sipendpoint.h"
#include "endpointmgr.h"
#include "logger.h"
#include "appevents.h"

//*****************************************************************************
// Function: SIPReleasingState::SIPReleasingState(SIPEndpoint *pSIPEndpoint)
// Description: Initializing constructor
// Return:  SIPReleasingState*
// Parameters: SIPEndpoint *pSIPEndpoint 
//*****************************************************************************
SIPReleasingState::SIPReleasingState(SIPEndpoint* pSIPEndpoint):
   SIPEPState(pSIPEndpoint)
{
   m_pSIPEndpoint = pSIPEndpoint;
}


//*****************************************************************************
// Function: SIPReleasingState::~SIPReleasingState()
// Description: Destructor
// Return:  
// Parameters: none 
//*****************************************************************************
SIPReleasingState::~SIPReleasingState()
{
}

//*****************************************************************************
// Function: void SIPReleasingState::ProcessEvent(METAEVENT metaevent)
// Description: Process an event
// Return: void 
// Parameters: METAEVENT metaevent 
//*****************************************************************************
void SIPReleasingState::ProcessEvent(METAEVENT metaevent)
{
   switch ( metaevent.evttype )
   {
      // GC/R4 events
      case GCEV_RELEASECALL:
         LOG_ENTRY(metaevent.evtdev, "SIPReleasing_state: GCEV_RELEASECALL received\n");
         ProcessRelease(metaevent);
         break;
      default:
         LOG_ERROR(metaevent.evtdev, "SIPReleasing_state: Unexpected event type: 0x%x\n", 
                   metaevent.evttype);
         break;
   }
}

//*****************************************************************************
// Function: void SIPReleasingState::ProcessRelease(METAEVENT metaevent)
// Description: Process call released event
// Return: void 
// Parameters: METAEVENT metaevent 
//*****************************************************************************
void SIPReleasingState::ProcessRelease(METAEVENT metaevent)
{
   // Advance to idle state
   m_pSIPEndpoint->ChangeState(IDLE_STATE);
   m_pSIPEndpoint->Notify(APP_SIP_ENDPOINT_DISCONNECTED);
}

//*****************************************************************************
// Function: void SIPReleasingState::Shutdown()
// Description: Process shutdown request
// Return: void 
// Parameters: none 
//*****************************************************************************
void SIPReleasingState::Shutdown()
{
  LOG_ENTRY(m_pSIPEndpoint->GetGCSIPHandle(), "Shutdown called in %s state.  No Op\n", GetStateStr());
}


