/**
* @file terminal.h
* @brief Declaration of Terminal class
* @date Feb. 20, 2007
*
* DIALOGIC CONFIDENTIAL
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#ifndef  _TERMINAL_H
#define  _TERMINAL_H

#include "endpointmgr.h"

//*****************************************************************************
// Class: ::Terminal
// Description: Class which displays activity of 3G and SIP endpoints and 
//              Bridged calls to a formatted window using the NCURSES library
//*****************************************************************************
class Terminal
{
public:
   Terminal();
   ~Terminal();

   typedef enum
   {
      MAIN_MANUAL_PROMPT,
      QUITTING_PROMPT
   } E_PROMPT_TYPE;

   void RefreshWindow();
   void UpdatePrompt(E_PROMPT_TYPE promptType);
   void DisplayPrompt();
   void ResizeWindow();

private:
   void SetGetchProperties();
   const char *GetPromptStr();

   int m_NumRows;
   int m_NumColumns;

   int  m_NumEPs;
   int  m_NumSIPEPs;
   int  m_NumMMEPs;
   int  m_NumCalls;
   int  m_NumMedias;
   int  m_NumHairps;
   int  m_NumRTSPEPs;
   int  m_NumBridgedRtsp;
   int *m_pEPList;
   int *m_pSIPEPList;
   int *m_pMMEPList;
   int *m_pCallList;
   int *m_pMediaList;
   int *m_pHairpList;
   int *m_pRTSPEPList;
   int *m_pBridgedRtspList;

   E_PROMPT_TYPE  m_PromptType;
};

#endif


