/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* DIALOGIC CONFIDENTIAL
*
* Copyright (C) 2006-2007 Dialogic Corporation. All Rights Reserved.
* The source code contained or described herein and all documents related
* to the source code ("Material") are owned by Dialogic Corporation or its
* suppliers or licensors. Title to the Material remains with Dialogic Corporation
* or its suppliers and licensors. The Material contains trade secrets and
* proprietary and confidential information of Dialogic or its suppliers and
* licensors. The Material is protected by worldwide copyright and trade secret
* laws and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted, distributed,
* or disclosed in any way without Dialogic's prior express written permission.
*
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
//***********************************************************************
//***********************************************************************
// Configuration.h: interface for the CDetectCfg class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_DETECTCONFIGURATION_H__3F1A529E_E713_4692_81C4_AAEA9606E1A1__INCLUDED_)
#define AFX_DETECTCONFIGURATION_H__3F1A529E_E713_4692_81C4_AAEA9606E1A1__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000


//
//  Device type codes
//
typedef enum {
// device type
    DEV_NONE,           // who cares
    DEV_DX,             // voice, for example dxxxB2C2    
    DEV_IPM,            // media, for example ipmB1C6
    DEV_IPT,            // ip, for example iptB1T1
    DEV_CNFBOARD,       // conference board, for example cnfB1
    DEV_CNFCONFERENCE,  // conference, for example cnfB1C3
    DEV_CNFPARTY,       // conference party, for example ptyB1C3
    DEV_DTI,            // dti, for example dtiB1T1
    DEV_REST            // none a device of interest in this demo (dcbB1, etc.)
}DLG_DEVICE_TYPE;


//-----------------------------------------------------------
// Double-list for reserving objects (devices), identify by name (string)
// m_Used is a list of already reserved devices 
// m_UnUsed is a list of non-reserved devices
//
//  Define()  => add device to UnUsed list. Use Define() to add detected devices
//  Reserve() => move device from UnUsed to Used list and return it's name
//  Reserve(name) => move specific device from UnUsed to Used list
//  UnReserve(name) => move specific device from Used to UnUsed list
//  UnReserve() => move all devices from Used to UnUsed list
//----------------------------------------------------------- 
class CDeviceList : public CNamedObj {
public:
    CDeviceList(const char *name) :CNamedObj(name){
       DEV_OBJECT_NAME="CDeviceList";
    };

    ~CDeviceList(){
        if (m_Used.size() != 0){
            GLBLOG(LOG_ERR1, DEV_OBJECT_NAME, "APP ERROR! ~CDeviceList():: There are still %d reserved devices in use:", m_Used.size());
            m_Used.Dump(GLBLOGOBJ);
        }
    };

    size_t ReservedSize(){
        return m_Used.size();
    }

    size_t UnReservedSize(){
        return m_UnUsed.size();
    }

    void Dump() {
        if (m_Used.size() ){
           GLBLOG(LOG_APP, DEV_OBJECT_NAME, "  == %s devices(Reserved) ==", GetName());
               m_Used.Dump(GLBLOGOBJ);
        }
        if (m_UnUsed.size()){
           GLBLOG(LOG_APP, DEV_OBJECT_NAME, "  == %s devices(UnReserved) ==", GetName());
               m_UnUsed.Dump(GLBLOGOBJ);
        }
    }

    // add to unrservred list ( newly detected device )
    bool Define(const char *name){
        bool brc = false;
           list<PNamedObj>::iterator pos;
           // TBD Multithread:: Lock here
           if ( !m_UnUsed.Find(&pos,name) ){
                 brc = m_UnUsed.Define(name);
           }
           // TBD Multithread:: UnLock here
           if (brc ){
               GLBLOG(LOG_DBG, DEV_OBJECT_NAME, "%s:: Defined %s", GetName(), name);
           } else {
               GLBLOG(LOG_ERR1, DEV_OBJECT_NAME, "%s:: Not Defined %s", GetName(), name);
           }
        return brc;
    }

    //-----------------------------------------------------------------------
    // Find appropriate device name and reserve for use from calling object
    // if *name is specified, this is a request to reserve specific name
    // Returns bool (true = success)
    bool Reserve(const char **name) {
        bool brc = false;
        CNamedObj *pObj = m_UnUsed.front();
        // TBD Multithread:: Lock <this> here
           if (m_UnUsed.size() > 0 ){
               if (*name) {
                   // Reserve specific
                   list<PNamedObj>::iterator pos;
                   if ( m_UnUsed.Find(&pos, *name) ) {
                       m_Used.splice(m_Used.end(), m_UnUsed, pos);
                   }                     
               } else { 
                   // reserve any
                   m_Used.splice(m_Used.end(), m_UnUsed, m_UnUsed.begin());
                   brc = true;
               }
           }
        // TBD Multithread:: UnLock <this> here
           if (brc ){
               *name = pObj->GetName();  // pObj is valid after splice
               GLBLOG(LOG_DBG, DEV_OBJECT_NAME, "%s:: Reserve %s", GetName(), *name);
           } else {
               GLBLOG(LOG_ERR2, DEV_OBJECT_NAME, "%s:: Cannot reserve device - container is empty", GetName());
           }
           return brc;
    }

    // UnReserve specific device 
    bool UnReserve(const char *name) {
         bool brc = false;
         if (name) {
             list<PNamedObj>::iterator pos;
             // TBD Multithread:: Lock <this> here
             if ( m_Used.Find(&pos,name) ){
                    CNamedObj *pObj = *pos;
                    GLBLOG(LOG_DBG, DEV_OBJECT_NAME, "%s: UnReserve %s", GetName(), pObj->GetName());
                    m_UnUsed.splice(m_UnUsed.end(), m_Used, pos);
                  brc = true;
             }else {
                    GLBLOG(LOG_ERR1, DEV_OBJECT_NAME, "%s: UnReserve failed: %s", GetName(), name);
             } 
             // TBD Multithread:: UnLock <this> here
         } // if name
         return brc;
    }

    // Un reserve all objects that are already reserved
    bool UnReserve() {
         list<PNamedObj>::iterator pos;
         CNamedObj *pObj;
         // TBD Multithread:: Lock <this> here
             while(m_Used.size() ) {
                   pos = m_Used.begin();
                   pObj = *pos;
                   GLBLOG(LOG_DBG, "CDeviceList", "%s: UnReserve %s", GetName(), pObj->GetName());
                   m_Used.erase(pos);
                   m_UnUsed.push_back(pObj);
             } 
         // TBD Multithread:: UnLock <this> here
         return true;
     }
     size_t GetSize(){
         return m_UnUsed.size();
     } 

private:
        // TBD Multithread:: Define Lock object here
        CObjList m_UnUsed;
        CObjList m_Used;
        const char *DEV_OBJECT_NAME;
}; // class CDeviceList



//
//  Detect Host name and address
//
class CDetectInet {
  public:
      CDetectInet();

      virtual ~CDetectInet(){
          str_deletestoredstring(&m_host_addr);
      }

      const char *GetHostAddr(){
          return m_host_addr;
      }

      const char *GetHostName(){
          return m_host_name;
      }

  private:
     //
     // HOST name and address
     char m_host_name[256];
     char *m_host_addr;       // IPVR4 dot notation
};
//
//  Detect Configiration
//    Detect all dx_, dti_ (PSTN), ipt, ipm and cnf devices
//    Build appropriate DeviceList for each of them
//
//--------------------------------------------------------------------
class CDetectCfg : public CDetectInet {
public:
    CDetectCfg(PCnfDemoPrm pAppPrm)
                :  m_DxxDevices("DXX"),
                   m_DtiDevices("DTI"),
                   m_IpmDevices("IPM"),
                   m_CnfBoards("CNFBRD"),
                   m_IptDevices("IPT"),
                   m_OtherDevices("REST"),
                   m_pAppParams(pAppPrm),
                   detected_dx(0){
	};
    
    virtual ~CDetectCfg(){
    };

    // Detect configuration
    bool DetectConfiguration();

    // Reserve device 
    bool Reserve(DLG_DEVICE_TYPE type, const char **name);

    // UnReserve specific device
    bool UnReserve(DLG_DEVICE_TYPE type, const char *name);

    // UnReserve all devices of given type
    bool UnReserve(DLG_DEVICE_TYPE type);

    // UnReserve all devices of all types
    bool UnReserve();

    void Dump();
    void DumpSize();
    size_t GetNumberOf(DLG_DEVICE_TYPE type);

private:
    // Detect configuration
    bool DetectVirtualBoardConfiguration(SRLDEVICEINFO *pInfo);
    bool DetectPhysicalBoardConfiguration(AUID auid);
	
    // 
    // Add detected device to appropriate list
    bool Define(DLG_DEVICE_TYPE type, const char *name);
    
    // Confirm play/record capabilities
    bool ConfirmDxx(const char *dev_name);
   
    CDeviceList m_DxxDevices;   // contains only play/record capable devices
    CDeviceList m_DtiDevices;   // all ISDN/T1/E1 network devices
    CDeviceList m_IpmDevices;   // Ipm devices

    CDeviceList m_CnfBoards;    // Cnf Boards  ( board devices )
    CDeviceList m_IptDevices;   // IPM devices

    CDeviceList m_OtherDevices; // Others

private: 
    class CnfDemoPrm * m_pAppParams;
    size_t detected_dx;         // save time not to look for more than you need
// Notes:
// 1. Conference devices cannot be queried before cnf_open
// 2. Number and names of ipt devices are known from gc_Start parameters
    

}; // class CDetectCfg


#endif // !defined(AFX_DETECTCONFIGURATION_H__3F1A529E_E713_4692_81C4_AAEA9606E1A1__INCLUDED_)
