/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* DIALOGIC CONFIDENTIAL
*
* Copyright (C) 2006-2007 Dialogic Corporation. All Rights Reserved.
* The source code contained or described herein and all documents related
* to the source code ("Material") are owned by Dialogic Corporation or its
* suppliers or licensors. Title to the Material remains with Dialogic Corporation
* or its suppliers and licensors. The Material contains trade secrets and
* proprietary and confidential information of Dialogic or its suppliers and
* licensors. The Material is protected by worldwide copyright and trade secret
* laws and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted, distributed,
* or disclosed in any way without Dialogic's prior express written permission.
*
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
//***********************************************************************
//***********************************************************************
// product_versions.h:
//
// Adjust for different product releases and branches 
// Requires preprocessor definition such as _HMP30, _HMP10, etc
//
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_PRODUCT_VERSIONS_H__3F1A529E_E713_4692_81C4_AAEA9606E1A1__INCLUDED_)
#define AFX_PRODUCT_VERSIONS_H__3F1A529E_E713_4692_81C4_AAEA9606E1A1__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000


// #define here Features:
//  _FR2619 (in cnflib.h)


// Only one version is defied in project properties
// currently supported versions:
// _HMP30
// _HMP15


// Enclose feature dependent code in
// #  ifdef FEATURE_XYZ
//
// #  endif



// Define here release inheritance:
// The fact that HMP3.0 is windows, 1.5 is Linux is irrelevant
// All that matters is if one is superset for the other
//

// Version _HMP31 us superset of _HMP30
#ifdef _HMP31
  # define _HMP30   // if this is the case
#endif

// Version _HMP30 us superset of _HMP15
#ifdef _HMP30
  # define _HMP15   // if this is the case
#endif


// Define here features that were introduced in HMP31
#ifdef _HMP31
//
#endif

//
// Define here features that were introduced in HMP30
#ifdef _HMP30
#  define IPM_SET_ECHOCANCEL
#  define _FR2619
#endif

//
// Define here features that were introduced in HMP30
#ifdef _HMP15
  // #define FEATURE_123 ...
#endif


//
// Preprocessor variable compatibility check
//
# ifdef LINUX
#    ifdef WIN32
#  	    error "CNF demo: cannot accept both #define's:  WIN32 and LINUX"
#    else 
//      # Ok, this is LINUX RELEASE
#       define OSNAME "LINUX"
#    endif
# else 
#    ifdef WIN32
//      #Ok, this is , Windows release 
#       define OSNAME "WIN32"
#    else 
//      Neither Linux Nor Windows - did you mean Apple?
#  	     error "CNF demo: need to #define one of: WIN32 or LINUX"
#    endif 
# endif

// ... etc. add here more
#ifdef _HMP31
#   define RELNAME "HMP_3.1"
#elif _HMP30
#   define RELNAME "HMP_3.0"
#elif defined (_HMP15)
#   define RELNAME "HMP_1.5"
#else 
#   error "CNF demo: need to #define one of: _HMP31 _HMP30, _HMP15"
#endif

#define DEMO_VERSION RELNAME"_CnfDemo_"OSNAME

#ifdef PRINT_VERSION
# ifdef WIN32
#   pragma message     ("Compiling "DEMO_VERSION)
#   pragma message     ("  Features:")
#     ifdef _FR2619
#       pragma message ("    FR 2619(beep notify): Enabled")
#     else
#       pragma message ("    FR 2619(beep notify): Disabled")
#     endif // _FR2619
#     ifdef IPM_SET_ECHOCANCEL
#       pragma message ("    IPM_SET_ECHOCANCEL:   Enabled")
#     else
#       pragma message ("    IPM_SET_ECHOCANCEL:   Disabled")
#    endif // IPM_SET_ECHOCANCEL
# endif // WIN32
#endif // PRINT_VERSION

#endif // AFX_PRODUCT_VERSIONS_H__3F1A529E_E713_4692_81C4_AAEA9606E1A1__INCLUDED_
