/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* DIALOGIC CONFIDENTIAL
*
* Copyright (C) 2006-2007 Dialogic Corporation. All Rights Reserved.
* The source code contained or described herein and all documents related
* to the source code ("Material") are owned by Dialogic Corporation or its
* suppliers or licensors. Title to the Material remains with Dialogic Corporation
* or its suppliers and licensors. The Material contains trade secrets and
* proprietary and confidential information of Dialogic or its suppliers and
* licensors. The Material is protected by worldwide copyright and trade secret
* laws and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted, distributed,
* or disclosed in any way without Dialogic's prior express written permission.
*
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
//***********************************************************************
//***********************************************************************
// Util.cpp: Implementation of test-processing utilities and other.
//
//////////////////////////////////////////////////////////////////////
#define _CRT_SECURE_NO_WARNINGS
// ignore security warning about ctime
#include <time.h>
#undef _CRT_SECURE_NO_WARNINGS

#include <sys/timeb.h>
#include "utils.h"


//*****************************************************************************
// Purpose	: 
//    Signal TMO if timer is started before more than specific number of ms 
// Parameters:	
//    none
// Returns:	
//    true if timer has expired
//    false if timer is off or if it is not expired yet
//*****************************************************************************
bool CTimer::CheckTimer() {
    if (m_timer.time) {
        struct timeb now;
        struct timeb diff;
        ftime(&now);
        timeb_diff(&diff, &m_timer, &now);
        if ( !time_isgreater(time_expire, &diff) ){
              StopTimer();
            return true;
        } // if timeout
    } // if timer is started
 return false;
}

//*****************************************************************************
// Purpose	: 
//    obtain the time set by the system and convert to string "hh:mm:ss.mmm"
// Parameters:	
//    none
// Returns:	
//    const char * 
//*****************************************************************************
const char * time_asstring() {
 static char sysTime[64];
 struct timeb tstruct;
 char timeBuf[32];

  ftime(&tstruct);
  str_safecopy(timeBuf, sizeof(timeBuf), ctime( &tstruct.time)  );
  timeBuf[19]=0;
  snprintf(sysTime, sizeof(sysTime), "%8s.%03d ",&(timeBuf[11]), tstruct.millitm);

 return sysTime;
}  //	End of function()

//*****************************************************************************
// Purpose	: 
//    calculate difference between 2 time()'s 
// Parameters:	
//    none
// Returns:	
//    none ( returns result in *result)
//*****************************************************************************
//--------------------------------------------------------------------
void timeb_diff(struct timeb * result,
	   		    struct timeb * bgntime,
			    struct timeb * endtime){
int diff;
 
	result->time     = (endtime->time - bgntime->time);
	diff   = (endtime->millitm - bgntime->millitm);

	while ( diff < 0 ) {
		result->time--;
		diff+=1000;
	}
	result->millitm = (unsigned short)diff;
	result->time += result->millitm/1000;
	result->millitm %= 1000;
 return;
}
//*****************************************************************************
// Purpose	: 
//    determine if given timeb is greater than given number of milliseconds
// Parameters:	
//    int milliseconds and timeb* time
// Returns:	
//    bool - true if milliseconds is greater
//*****************************************************************************
bool time_isgreater(int milliseconds, struct timeb * time){
  int sec = milliseconds / 1000;
  if (sec > time->time) {
      return true;
  }
  if (sec < time->time) {
      return false;
  }
  return (milliseconds % 1000) > time->millitm;    
}

//<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><>
// Allocate & delete new string
// The following routines are used to allocate and release string holders
//<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><>
//*****************************************************************************
// Purpose	: 
//    delete previously allocated string holder and clean Holder.  
// Parameters:	
//    address to the holder (char **)
// Returns:	
//    bool (true)
//*****************************************************************************
bool str_deletestoredstring(char **Holder){
	if (*Holder) {
		delete [] *Holder;
		*Holder = 0;
	}
 return true;
}  //	End of function()

//<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><>
// string copy and movement
// The following routines are used to move strings
// Boundary check is guaranteed. Destination may be truncated.
// Destination is Guaranteed to be terminated with 0
//<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><>
//
// Internal routine used to copy strings
//-----------------------------------------------------------------------------
static char * str_copywhile(char *dest, const char *src, size_t *maxlen){

 if (0 == src){
     return dest;
 }
 while( *maxlen > 1) {
		*dest = *src;
		if (0 == *src) {
			break;
		}
		dest++;
		src++;
		--(*maxlen);
 } 
 return dest;
}  //	End of function()

//*****************************************************************************
// Purpose	: 
//    allocate memory to hold a string + trailing '\0'
//    assign empty string
// Parameters:	
//    holder addr (char **) 
//    requested max length
// Returns:	
//    bool (true = success)
//*****************************************************************************
bool str_storestring(char **Holder, size_t length){
  if (*Holder) {
	   delete [] *Holder;
	   *Holder = 0;
  }

  if (length) {
	  *Holder = new char[length+1];
      **Holder = 0;
  } else {
	  return true;
  }

  return (*Holder != 0);
}  //	End of function()

//*****************************************************************************
// Purpose	: 
//    allocate memory to hold a string + trailing '\0'
//    store given value
// Parameters:	
//    holder addr (char **) and value(string) to store
// Returns:	
//    bool (true = success)
//*****************************************************************************
bool str_storestring(char **Holder, const char *value){
  if ( value ){
	  size_t len = strlen(value)+1;
      if ( !str_storestring(Holder,len)){
          return false;
      }
      str_safecopy(*Holder, len, value);
  }else {
      str_storestring(Holder,(size_t)0);
  }
  return true;
}  //	End of function()

//*****************************************************************************
// Purpose	: 
//    a safe strcpy. 
//    Destination is guarantees to be 0 terminated and not to overflow
//    Truncate the string if destination is shorter than source 
// Parameters:	
//    destination, size of the destination buffer, source
// Returns:	
//    char * (destination)
//*****************************************************************************
//------------------------------------------------------------------
char * str_safecopy( char *dest,
                     size_t maxlen, 
                     const char *src){
char *res = dest;

 if (maxlen == 0){
	 return dest;
 }

 dest = str_copywhile(dest, src, &maxlen);

 *dest=0;
 return res;
}  //	End of function()

//*****************************************************************************
// Purpose	: 
//    trim trailing space (spaces, '\n', '\r', '\t' and '\f' )
// Parameters:	
//    destination
// Returns:	
//    char * (destination)
//*****************************************************************************
char * str_rtrim(char *destination){
 size_t len = strlen(destination);
 char *ch = destination+len-1;
 while ( len > 0 ){
     --len;
     if ( isspace(*ch) ){
         // skip beginning spaces
         --ch;
     }
 }
 while (!isspace(*ch) ){
     // skip 
     ++ch;
 }
 *ch = 0;
 return destination;
}  //	End of function()

//*****************************************************************************
// Purpose	: 
//    trim beginning space (shift left destination) (spaces, '\n', '\r', '\t' and '\f' )
// Parameters:	
//    destination
// Returns:	
//    char * (destination)
//*****************************************************************************
char * str_ltrim(char *destination){
 size_t len = strlen(destination);
 size_t bgn = 0;
 while (destination[bgn]) {
     if ( isspace(destination[bgn]) ){
        ++bgn;
        continue;
     }
     // move starting with dest
     if ( bgn && ( bgn < len ) ) {
          memmove(destination, destination+bgn, len-bgn+1);
     }
     return destination;
 }
 // empty string
 *destination = 0;
 return destination;
}  //	End of function()

//*****************************************************************************
// Purpose	: 
//    string concatenation, boundary check and terminate with '\0' in all cases
// Parameters:	
//    destination, size of destination, string to concatenate
// Returns:	
//    char * (destination)
//*****************************************************************************
char * str_safecat( char *dest, size_t maxlen, const char *src1){
char *res = dest;
  if (maxlen == 0){
	  return dest;
  }
  size_t len = strlen(dest);

  if (len < maxlen-1) {
      dest = &(dest[len]);
  } else {
      // This string is already damaged
      return res;
  }
  maxlen -= len;
  dest = str_copywhile(dest, src1, &maxlen);
  *dest=0;
 return res;
} //	End of function()

//*****************************************************************************
// Purpose	: 
//    string concatenation, boundary check and terminate with '\0' in all cases
// Parameters:	
//    destination, size of destination, 2 strings to concatenate
// Returns:	
//    char * (destination)
//*****************************************************************************
char * str_safecat( char *dest, size_t maxlen, const char *src1,
                                               const char *src2){
char *res = dest;
 if (maxlen == 0){
	 return dest;
 }

 size_t len = strlen(dest);

 if (len < maxlen-1) {
     dest = &(dest[len]);
 }else {
      // This string is already damaged
      return res;
 }

 maxlen -= len;
 dest = str_copywhile(dest, src1, &maxlen);
 dest = str_copywhile(dest, src2, &maxlen);
 *dest=0;

 return res;
} //	End of function()

//*****************************************************************************
// Purpose	: 
//    string concatenation, boundary check and terminate with '\0' in all cases
// Parameters:	
//    destination, size of destination, 3 strings to concatenate
// Returns:	
//    char * (destination)
//*****************************************************************************
char * str_safecat( char *dest, size_t maxlen, const char *src1,
                                               const char *src2,
                                               const char *src3){
char *res = dest;
 if (maxlen == 0){
	 return dest;
 }

 size_t len = strlen(dest);

 if (len < maxlen-1) {
    dest = &(dest[len]);
 }else {
      // This string is already damaged
      return res;
 }

 maxlen -= len;
 dest = str_copywhile(dest, src1, &maxlen);
 dest = str_copywhile(dest, src2, &maxlen);
 dest = str_copywhile(dest, src3, &maxlen);
 *dest=0;

 return res;
} //	End of function()

//*****************************************************************************
// Purpose	: 
//    compare strings, not case sensitive, accepts NULL pointers (less than any other )
// Parameters:	
//    strings to compare
// Returns:	
//    int >0 (first is greater) =0 (equal) <0 (second is greater)
//*****************************************************************************
int str_compare(const char *s1, const char *s2){
int rc;
 if (s1 == 0) {
	 return (s2 == 0)?COMPARE_EQUAL:COMPARE_LESS;
 }
 if (s2 == 0) {
	 return COMPARE_GREAT;
 }

 while (*s1 && *s2) {
	 if ( ( rc = ((unsigned)tolower(*s1) - (unsigned)tolower(*s2)) ) != 0 ) {
		 return rc;
	 }
	 ++s1;++s2;
 }
 return (*s1-*s2);
}  //	End of function()

//*****************************************************************************
// Purpose	: 
//    check if this string represent numeric value (can be 0xHEX and/or negative)
// Parameters:	
//    none
// Returns:	
//    true if it is a number
//*****************************************************************************
bool str_isnumber(const char *string){
     return str_getnumber(string,(int *)0);
} //	End of function()


//*****************************************************************************
// Purpose	: 
//    check if this string represent unsigned numeric value (can be 0xHEX )
//    if yes, load the value in *result
//    may overflow w/o warning if number is bigger than MAX UINT value
// Parameters:	
//    string
// Returns:	
//    true if it is a number + result ( if non zero ptr ) loaded 
//*****************************************************************************
static bool string2num(const char *string, unsigned int *result){
int base = 10;
unsigned int tmp = 0;

// Hex base?
    if    ( (*string == '0') 
        && ( tolower(*(string+1)) == 'x' ) ){
        base = 16;
        string+=2;
    }

 // Process
    while (*string){
        if (    (*string >= '0')
             && (*string <= '9' ) ){
            // good for decimal and hex
            tmp = tmp * base + (*string-'0');
        }else if (base == 16) {
           int dig = tolower(*string)-'a'+10;
           if ( (dig >= 10) && (dig <= 15) ) {
               tmp = tmp*16+ dig;
           }else {
               //non hex digit
               return false;
           }
        }else {
            return false;
        }
        ++string;
    } // while *string

    if (result) {
        *result = tmp;
    }
    return true;
} //	End of function()

//*****************************************************************************
// Purpose	: 
//    skip beginning spaces
//    check if this string represent unsigned numeric value (can be 0xHEX )
//    if yes, load the value in *result
//    may overflow w/o warning if number is bigger than MAX UINT value
// Parameters:	
//    string
// Returns:	
//    true if it is a number + result ( if non zero ptr ) loaded 
//*****************************************************************************
bool str_getunsignednumber(const char *string, unsigned int *result){

 // skip spaces;
    while( isspace(*string) && *string ) { 
           ++string;
    } 
    
    return string2num(string, result);
} //	End of function()

//*****************************************************************************
// Purpose	: 
//    check if this string represent numeric value (can be 0xHEX and/or negative)
//    if yes, load the value in *result
//    may overflow w/o warning if number is bigger than MAX INT value
// Parameters:	
//    string
// Returns:	
//    true if it is a number + result ( if non zero ptr ) loaded 
//*****************************************************************************
bool str_getnumber(const char *string, int *result){
bool neg = false;
unsigned int u_result;

 // skip spaces;
    while( isspace(*string) && *string ) { 
           ++string;
    } 

 // negative?
    if (*string == '-') {
        ++string;
        neg = true;
    }
    bool brc = string2num(string, &u_result);
    // store value
    if (result) {
        if (brc  ) {
            if (neg) {
               *result = -(signed)u_result;
            }else {
               *result = (signed)u_result;
            }
        }else {
            *result = 0;
        }
    }
    return brc;
} //	End of function()

//*****************************************************************************
// Purpose	: 
//    find name for given code in given table
// Parameters:	
//    code, holder for name if found, structure to search in
// Returns:	
//    true = found
//    false = not found
//    name addr in *name
//*****************************************************************************
bool str_findname(int code,                // event code
                  const char **name,       // holder for name
                  const NAME_TABLE *table ){ // where to search
    while (table->name){
        if (table->code == code) {
            *name = table->name;
            return true;
        }
        ++table;
    }
 *name = "<unknown name>";
 return false;
}

//*****************************************************************************
// Purpose	: 
//    find name for given code in given table
// Parameters:	
//    code, holder for name if found, structure to search in
// Returns:	
//    true = found
//    false = not found
//    name addr in *name
//*****************************************************************************
bool str_findcode(const char *name,     // given name
                  int *code,            // holder for code
                  const NAME_TABLE *table ){  // where to search
    while (table->name){
        if ( COMPARE_EQUAL == str_compare(table->name , name) ) {
            *code = table->code;
            return true;
        }
        ++table;
    }
 *code = -1;
 return false;
}

//*****************************************************************************
// Purpose	: 
//     ret_code <> 0, Display message and wait key Enter
// Parameters:	
//    [in] ret_code 
//    [in] message
// Returns:	
//    none
//*****************************************************************************
void con_wait_a_key(int ret_code, const char *txt){
    if ( ret_code ){
         printf("\n%sPress <Enter>...",txt);
         char buffer[10];
         fgets(buffer,2, stdin);
    }
 return;
}

#  ifndef WIN32
//*****************************************************************************
// Purpose	: 
//    Block calling thread for specified number of milliseconds
// Parameters:	
//    number of milliseconds
// Returns:	
//    none
//*****************************************************************************
void Sleep(unsigned long milliseconds){
    struct timeval tval;
      tval.tv_sec  = milliseconds / 1000;
      tval.tv_usec = (milliseconds % 1000L)*1000;
      select(0,NULL,NULL,NULL,&tval);
  return ;
}  //	End of function()
#  endif




//////////////////////////////////////////////////////////////////////
// End of Utils.cpp
//////////////////////////////////////////////////////////////////////
