//***********************************************************************
// Copyright  2005, Intel Corporation. 
// All rights reserved All names, products, and services mentioned  
// herein are the trademarks or registered trademarks of their respective 
// organizations and are the sole property of their respective owners
//***********************************************************************

// ConfManager.h: interface for the CConfManager class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(CLASS_CONFMANAGER)
#define CLASS_CONFMANAGER

#include <ctinfo.h>
#include <msilib.h>
#include <dcblib.h>

#include <vector>
#include <list>

class CIpDev;

enum { BAD_PASSCODE = 0x10, NO_SYSTEM_RESOURCE }; 

struct ConfFeatures
{
	struct activeTalk
	{
		int at_enabled;
		int at_interval;
		int at_algorithm;
	};
	
	int         cf_toneClamping;
	activeTalk  cf_activeTalker;
	char        cf_muteDigits[2];
	bool        cf_sipEnable;   
	MS_VOL      cf_volumeDigit; // volume control
};

class CConference;

class CConfManager  
{
public:
	CConfManager();
	virtual ~CConfManager();

private:
struct confInfo
{
// info from config file
	int  ci_bridgeNumber;
	char ci_passcode[24];
	bool ci_detectDigits;
	bool ci_echoCancellerEnabled;
}; 

	std::vector<confInfo>  m_confInfoArray;  // array of confInfo 

	std::vector<int>    m_hDspArray; // array of DSP handles
	int         m_numberOfDsp;
	int         m_totalResourceCount; // number of all conf resources

	ConfFeatures m_confFeatures;

	std::list<CConference *>    m_confList; // linked list of all existing confs 
	char    m_txt[256];    // some storage for screen output

	void    removeFromList(CConference * confToRemove);
	void    parseBoardParameters(const char * fileBuf);
	int     parseConfInfo(const char * fileBuf);

	CConference *   findConference(int bridgeNumber, int confId = 0);
	CConference *   initNewConference(int hDsp);


	int setBoardLevelPrm(const char * fileBuf);
	int findAvailableResource(); // returns any dsp, with resources >0 

	int validatePasscode(const char * pascode); // returns bridgeNum or -1;

	void    reportError(int type, const char * txt);

public:
	void displayActiveTalkers();

	int  initConfManager(const char * fileBuf);
	void destroyConfManager();
	int  loadConferenceTable(const char * fileBuf);
	int  loadDefaultConfig();
	void updateConferenceTable();

	int  addToConference(CIpDev * ipDev);
	int  removeFromConference(CIpDev * ipDev);
	void destroyConference(int bridgeNumber);

	void startMonitor(CIpDev * monDev, int bridgeNumber);
	void stopMonitor(int bridgeNumber);

	int  getConfResources();
	int  processEvenet(long evt);
	void processDigits(CIpDev * ipDev); 
	void showStatistics();
	void logOut(int type, const char * info, int windNumber = 1);
};

#endif	// #if !defined(CLASS_CONFMANAGER)
