//***********************************************************************
// Copyright  2005, Intel Corporation. 
// All rights reserved All names, products, and services mentioned  
// herein are the trademarks or registered trademarks of their respective 
// organizations and are the sole property of their respective owners
//***********************************************************************
// IpDev.h: interface for the CIpDev class.
//
//////////////////////////////////////////////////////////////////////

// IpDev.h: interface for the CIpDev class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(CLASS_IPDEV)
#define CLASS_IPDEV

#include <srllib.h>
#include <gclib.h>
#include <dxxxlib.h>
#include <dtilib.h>	
#include <gcerr.h>
#include <gcip.h>
#include <gcip_defs.h>
#include <gccfgparm.h>


#define USR_EVENT_EXIT      (TDX_UNKNOWN + 2)
#define USR_EVENT_OPEN_CMPT (TDX_UNKNOWN + 3)

enum PortState {
	BLOCKED_STATE, CALL_FAIL_STATE, NULL_STATE, CONNECTED_STATE,
	DISCONNECTED_STATE, DROPPING_STATE, OFFERED_STATE, ACCEPTED_STATE,
	DIALING_STATE, ALERTING_STATE
};


#define CALL_CONNECTED  0x101
#define DIGITS_RECEIVED 0x102
#define USER_DROPPED    0x103
#define SINGLE_DIGIT    0x104


class CIpDev  
{
public:
	CIpDev();
	virtual ~CIpDev();
private:
	int         m_hVox;
	LINEDEV     m_hDev;
	CRN         m_crn;
	long        m_tsn;
	long        m_tsv;
	int         m_channelNum;
	int         m_bridgeNumber;

	PortState   m_portState;
	int         m_playAttempt;
	int         m_dropFlag;



	DX_IOTT     m_iott;
	DV_TPT      m_tpt[3];
	DX_XPB      m_xpb;
	DV_DIGIT    m_digBuf;
	char        m_voxDevName[12];
	char        m_netDevName[12];
	static char m_devTxt[256];
	
	int     setCapabilities();
	int     setDtmfTransferMode(char xferMode);

	int     release();
	int     answer();
	int     accept();
	int     restart();
	void    onExtension(GC_PARM_BLKP gcParmBlk);

	int     getDigits(int timeout = 200);

	void    checkError(const char * funcName);
	void    logOut(int type, const char * info, int printConsoleNum , bool voxDevInfo = false);

	
public:
	int     openDev(int channel);
	int     closeDev();
	int     enableCalls(bool enable);
        int     enableState(bool enable);
	int     dti_Listen(long ts, int mode);
	int     dx_Listen(long ts);
	void    dti_Unlisten();
	void    dx_Unlisten();

	int     drop(int cause = GC_NORMAL_CLEARING); // drop call immediately
	int     dropCallGracefully(char * byeFileName); // play Goodbye then drop

	int     collectPasscodeDigits(char * playFileName, int numOfAttempts);
	int     collectPasscodeDigits(char *playFileName);
	const 
	char *  getDigBuffer();
	int     playFile(const char * file);
	int     recordVoice(char * file, int timeout = 200);
	int     processEvent();

	void    enableSingleDigit(bool digEnable = true);
	void    stopVoice();
	bool    isIdle() const;

	// inline access function:
	inline long     getMediaDev() const { return (long)m_hVox;};
	inline LINEDEV  getLineDev() const {return m_hDev;};
	inline long     getTxSlot() const { return m_tsn;};
	inline long     getVoiceTxSlot() const { return m_tsv;};
	inline int      getConfBridgeNumber() const { return m_bridgeNumber;};
	inline void     setConfBridgeNumber(int bridgeNum) {m_bridgeNumber = bridgeNum;};
	inline int      getChannelNumber() const { return m_channelNum;};
};

#endif	// #if !defined(CLASS_IPDEV)
