/*****************************************************************************
 * Copyright (c) 2002 Intel Corporation
 * All Rights Reserved.  All names, products, and services mentioned herein
 * are the trademarks or registered trademarks of their respective organizations
 * and are the sole property of their respective owners
 **************************************************************************/

/*****************************************************************************
 * Filename:                 newscrn.cpp
 ****************************************************************************/

#include "newscrn.h"
#include <curses.h>

myWINDOW scrn_makewin(int height, int width, int y, int x)
{
	return newwin(height, width, y, x);
}

void scrn_box(myWINDOW threadWindow)
{
	box((WINDOW*)threadWindow, ACS_VLINE, ACS_HLINE);
}

myWINDOW scrn_initscr(void)
{
	return initscr();
}

int scrn_wrefresh(myWINDOW win)
{
	return wrefresh((WINDOW *)win);
}

int scrn_wclear(myWINDOW win)
{
	return wclear((WINDOW *)win);
}


int scrn_waddstr(myWINDOW win, int y, int x, const char *str)
{
	return mvwaddstr((WINDOW *)win, y, x, str);
}

int scrn_halfdelay(int tenths)
{
	return halfdelay(tenths);
}

int scrn_refresh( void )
{
	return refresh();
}

int scrn_init_pair(short pair, short fg, short bg)
{
	return init_pair(pair, fg, bg);
}

int scrn_wcolor_set(myWINDOW win, short color, void *opts)
{
	return wcolor_set((WINDOW *)win, color, opts);
}


int scrn_start_color(void)
{
	return start_color();
}

int scrn_wmove(myWINDOW win, int y, int x)
{
	return wmove((WINDOW *)win, y, x);
}

int scrn_delwin(myWINDOW win)
{
	return delwin((WINDOW *) win);
}
 
int scrn_endwin(void)
{
	return endwin();
}
