//***********************************************************************
// Copyright  2005, Intel Corporation. 
// All rights reserved All names, products, and services mentioned  
// herein are the trademarks or registered trademarks of their respective 
// organizations and are the sole property of their respective owners
//***********************************************************************

// Util.cpp: Implementation of test-processing utilities and other.
//
//////////////////////////////////////////////////////////////////////
#if defined(_WIN32)
#include <windows.h>
#else
#include <sys/types.h>
#include <unistd.h>
#endif
#include <string.h>
#include <ctype.h>


#include "pdl.h"
#include "AppLog.h"
#include "utils.h"
#include <time.h>
#include <sys/timeb.h>


//*****************************************************************************
// Function : 
//    readConfigFile()
// Purpose  : 
//    Reading the configuration file to buffer
// Parameters:  
//    Parm1 <char * configFileName><input>
// Return type: char * - buffer with the file content
//*****************************************************************************
char * ReadConfigFile(const char *configFileName)
{
	FILE * fstr = fopen(configFileName, "rb");
	if(fstr == NULL)
	{
#if 0
		appConsole->printInfo(WARN, (char *)configFileName, "Cannot open config file", 1); 
#endif
		printInfo(WARN, (char *)configFileName, "Cannot open config file", brdStatusWindow);
		return NULL;
	}
	int length;
	fseek(fstr, 0, SEEK_END);
	length = ftell(fstr);
	fseek(fstr, 0 ,SEEK_SET);
	if(length < 4) // 
	{
#if 0
		appConsole->printInfo(WARN, (char *)configFileName,
			"Wrong conf file sysntax, load default config", 1);
#endif
		//printInfo(WARN, (char *)configFileName, "Wrong conf file sysntax, load default config", brdStatusWindow);
		fclose(fstr);
		return NULL;
	}
	char * fileBuf = new char[length +1];
	if(fread(fileBuf, sizeof(char), length, fstr) != length)
	{
#if 0
		appConsole->printInfo(WARN, (char *)configFileName, 
			"Error reading file", 1);
#endif
		//printInfo(WARN, (char *)configFileName, "Error reading file", brdStatusWindow);
		delete[] fileBuf;
		fclose(fstr);
		return NULL;
	}
	fclose(fstr);
	*(fileBuf + length) = 0;
	return fileBuf;
}

//*****************************************************************************
// Function : 
//    SkipComments()
// Purpose  : 
//    Used to parse the buffer and skip the comments 
// Parameters:  
//    Parm1 <char * bug><direction>
// Return type:
//    char *
//*****************************************************************************

char * SkipComments(char * buf)
{
	buf = SkipSpace(buf); 
	if(buf == 0) {
		return NULL;
	}
	while(buf)
	{
		if( (*buf == '#') || (*buf == '*') || (*buf == '!') )
		{
			buf = GetNextLine(buf); // skip this line
			buf = SkipSpace(buf);
		}
		else {
			break;
		}
	}
	buf = SkipSpace(buf);
	return buf;
}
	

//*****************************************************************************
// Function : 
//    SkipSpace()
// Purpose  : 
//    Used to parse the buffer and skip the empty space
// Parameters:  
//    Parm1 <char * bug><direction>
// Return type: 
//    char *
//*****************************************************************************
char * SkipSpace(char * buf)
{
	if(!buf)
		return NULL;
	while( (*buf) && isspace(*buf))
		buf++;
	if(*buf == 0) // EOF
		return NULL;
	return buf;
}



//*****************************************************************************
// Function : 
//    GetNextLine()
// Purpose  : 
//    Get to the next line in the configuration file
// Parameters:  
//    Parm1 <char * buf><direction>
// Return type: 
//    char *
//*****************************************************************************
char * GetNextLine(char * buf)
{
	buf = strchr(buf, '\n');
	if( ( buf == 0) || (*(++buf) == 0) ) // EOF
		return NULL;
	return buf;
}


//*****************************************************************************
// Function : 
//    getSystemTime()
// Purpose  : 
//    obtain the time set by the system to add it to the log file or console
// Parameters:  
//    none
// Return type: 
//    const char * 
//*****************************************************************************
const char * getSystemTime()
{
	struct tm tmClockAfter;
	time_t tCurrent=0;
	static char sysTime[32];
	timeb tstruct;
	time(&tCurrent);
	ftime(&tstruct);
	tmClockAfter = *localtime(&tCurrent);
	sprintf(sysTime, "%d:%d:%d:%d", tmClockAfter.tm_hour, tmClockAfter.tm_min, tmClockAfter.tm_sec,tstruct.millitm);   
	return sysTime;
}


#if !defined(_WIN32)

extern "C" {

int dx_fileopen(const char * filep, int flags, ...)
{
	va_list ap;                     /* variable argument (pmode) */
	int pmode;
	int handle;

	if (flags & O_CREAT) {
		// pmode must be specified if creating the file
		va_start(ap, flags);
		pmode = va_arg(ap, int);
		va_end(ap);
		handle = open(filep, flags, pmode);
	}
	else {
		handle = open(filep, flags);
	}
	return handle;
}

int dx_fileread(int handle, void * buffer, unsigned int count)
{
	int nRet;
	nRet = read(handle, buffer, count);
	return nRet;
}

int dx_filewrite(int handle, void * buffer, unsigned int count)
{
	int nRet;
	nRet = write(handle, buffer, count);
	return nRet;
}

int dx_fileclose(int handle)
{
	int nRet;
	nRet = close(handle);
	return nRet;
}

long dx_fileseek(int handle, long offset, int origin)
{
	long retOffset;
	retOffset = lseek(handle, offset, origin);
	return retOffset;
}

long dx_filefilelength(int handle)
{
	long len;
	long posCurr;

	posCurr = lseek(handle, 0L, SEEK_CUR);
	if (posCurr == -1L) {
		return -1;
	}

	len = lseek(handle, 0L, SEEK_END);
	if (len == -1L) {
		return -1;
	}

	posCurr = lseek(handle, posCurr, SEEK_SET);
	if (posCurr == -1L) {
		return -1;
	}

	return len;
}

}	/* extern "C" */

#endif

//////////////////////////////////////////////////////////////////////
// End of Utils.cpp
//////////////////////////////////////////////////////////////////////
