/**
* @file MultiMediaDemoVersion.cpp
* @brief Multimedia demo version stam
* @date Feb 16, 2007
*
* DIALOGIC CONFIDENTIAL 
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to 
* the source code ("Material") are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its 
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced, 
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual 
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*
* DESCRIPTION:
*       This is the 'more recent' version history file for the MultiMedia Demo
*
*       Version number looks like this:
*       "KEYWORD TMmmBBAA-<build> exename <optional string>"
*
* Where:
*       KEYWORD = DLcid
*       T  = type (0-Prod, 1-Beta, 2-Alpha, 3-Expr, 4-Special)
*       M  = major number (0-9)
*       mm = minor number (00-99)
*       BB = beta number  (00-99)
*       AA = alpha/experimental number (00-99)
*       <build> - build number (reset to 0 when major/minor/alpha/beta change)
*       <exename> - name of file this is a version of
*       <optional string> - optional comment string
*
************************************************************************************************/
/*
*                                                                ---Type: 0=Prod, 1=Beta, 2=Alpha, 3=Exp
*                                                               | -----Major Number
*                                                               ||  -----Minor Number
*                                                               || |  -----Beta Number
*                                                               || | |  -----Alpha/Exp Number
*                                                               || | | |
*                                                               || | | |
*                                                               vv v v v
*/
const char * MULTIMEDIADEMO_BINARY_VERSION_STRING      = "DLcid 31400000-14 MultiMediaDemo";
const char * MULTIMEDIADEMO_VERSION_STRING             = "31400000-14";

/*
********* MultiMediaDemo-Version 1.40-Build-14************************* Jun-2011 [PL]
1) Added H264 and AMRWB 3GP support   

********* MultiMediaDemo-Version 1.40-Build-13************************* Oct-2010 [JM]
1) Added H263+ support    

********* MultiMediaDemo-Version 1.40-Build-12************************* Jun-2010 [JM/SKS]
1) HMP3.1 fix, remove WB Codecs from Reserve Resource array.  WB Codecs Only supported in HMP4.1   

********* MultiMediaDemo-Version 1.40-Build-11************************* Jun-2010 [JM/SKS]
1) AMR-NB SDP Parse fix for no mode-set crash
2) G723 SDP parse fix for no bitrate crash

********* MultiMediaDemo-Version 1.40-Build-10************************* Jun-2010 [JM]
1) Makefile fix

********* MultiMediaDemo-Version 1.40-Build-9************************* May-2010 [JM]
1) Fixed SDP array length issue
2) Fixed rfc2833 dynamic PT issue

********* MultiMediaDemo-Version 1.40-Build-8************************* Apr-2010 [JM/DB]
1) Added H.264xcode support

********* MultiMediaDemo-Version 1.40-Build-7************************* Apr-2010 [SKS]
1) Fix parseOfferSdp to work with media level info (in addition to session level info)
2) Add Handling of IPMEV_ERROR on ipm_StartMedia.
3) Add PLAY_ACK_FAIL, PLAY_FAIL error handling.
4) Remove direct .3gp check for h263 files when native.

********* MultiMediaDemo-Version 1.40-Build-6************************* Mar-2010 [JM]
1) Fix Record Issue - not waiting for Stop Ack
2) Fix Eyebeam no audio issue - eyebeam expects RTP ports open when SIP OK is returned
	- Start media OnOffered, before mmAccept
        - provide 'waitonsipack' parameter to allow application to Wait on SIP Ack to start media

********* MultiMediaDemo-Version 1.40-Build-5************************* Feb-2010 [JM]
1) Added G722 & AMRWB Native Support
	- Added g722/amrwb files
2) Fixed Audio only Call support for Play/Record
3) Added 'dtmfdetectmode' cfg parameter to inband, rfc2833 only and SIP_INFO dtmf types
4) Added mm_Reset() and eventing at initialization
5) Added WAV file support
6) Added pcm16k linear support
7) Added 'tracelevel' cfg parameter for extra devugging levels
8) Added 'recordtimeout' cfg parameter to end Record after x sec.
9) Added 'userecordmsg' cfg parameter to support simultaneous play/record
10) Fixed RecordFail and RecordAckFail processing
11) Updated avfiles to Video Format 10 

********* MultiMediaDemo-Version 1.40-Build-4************************* Feb-2010 [PL]
Added H264 Native Support

********* MultiMediaDemo-Version 1.40-Build-3************************* Oct-2009 [JM]
1) Added SIP_ACK Event to wait to start media until remote sends SIP ACK 
   Previously started media on GC_ANSWERED event.
2) Fixed compilation issue with HMP3.1 and libmtk - Moved USE_MTK_API to Makefile
   HMP4.1, MMP, MMK  - MMDemo must be rebuilt to include MTK Overlay support
3) Fixed a couple small issues

********* MultiMediaDemo-Version 1.40-Build-2************************* Sep-2009 [JM]
1) Updated to compile under RH5update2 (gcc4.1)
2) Fixed .pcm play/record bug


********* MultiMediaDemo-Version 1.40-Build-1************************* Sep-2009 [SK]

// AMR MFPP, DVR, Image Play Record, MPEG4DCI and RTSP
// fixed bug in PopulateAnswerSDP function for CIF video for MPEG4
// added to get platform name and release in source rather than in Makefile
// added platform level check while parsing config file
// added check for xcode to make app compatible based on platform used
// removed audio/video codec information from config and make it dynamic based
// 							on supported codec by each platform
// RTSP dci fix
// fixed the bug where time description was being added one line for every call in Answer SDP
// if any audio or video codec is not matched the rejecting the call, also if
// there is no SDP in either Offered or ACK
// parsing /  answer / setup remote-local media and ipm_startmedia completed
// calls are working for native and transcoding both
//	corrected ParseAndStoreAudioAttributes() function error
// consider case where matching codec found for transcoding - working 
// corrected one way transcoding issue where it can now find matching codec as
// configured in config file with offered media into SDP
// fixed bug of not opening every alternate channel even if USE_RTSP!=1
// fixed bug when xcodedir value was wrong was continuing now exit from app
// made changes for USE_RTSP cases as well

// added Image Overlay

// SKS added these three functions
//  void BuildOverlay();
//  void ApplyOverlay();
//  void RemoveOverlay();
//  void DestroyOverlay();

//   void OnAddOverlay(void *pData);
//   void OnRemoveOverlay(void *pData);
//   void OnAddOverlayFail(void *pData);
//   void OnRemoveOverlayFail(void *pData);
//   void OnRemoveAllOverlays(void *pData);
//   void OnRemoveAllOverlaysFail(void *pData);

// SKS added these variables 

//   MTK_HANDLE hMtkImageTemplate;
//   MTK_HANDLE hMtkMediaFileTemplate;
//   MTK_FRAME_HANDLE hMtkFrameTemplate;
//   MTK_FRAME_HANDLE hObOverlayBoundingFrame;
//   OB_OVERLAY_HANDLE hObImageOverlayTemplate;

// fixed in mmdemo.cpp from rxdciqcifsize to txdciqcifsize, because of this
// even if txdciqcif value was configured into mmdemo.cfg file it was not able
// to use it since it checks size of rxdciqcifsize and if rxdciqcif is not
// defined it doesn't use txdciqcif value even



******************************************************************************************/

